<?php
/**
 * Customizer settings for Home News
 */

if ( ! function_exists( 'inspiry_home_news' ) ) :
	function inspiry_home_news( WP_Customize_Manager $wp_customize ) {

		/**
		 * News Panel
		 */
		$wp_customize->add_section( 'inspiry_home_news', array(
			'title'    => esc_html__( 'Blog', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_home_panel',
			'priority' => 160
		) );

		// news title
		$wp_customize->add_setting( 'inspiry_news_title', array(
			'default'           => esc_html__( 'Recent from Blog', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_control( 'inspiry_news_title', array(
			'label'    => esc_html__( 'Title', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_news',
			'settings' => 'inspiry_news_title',
			'type'     => 'text'
		) );

		// news description
		$wp_customize->add_setting( 'inspiry_news_description', array(
			'sanitize_callback' => 'wp_kses_post'
		) );

		$wp_customize->add_control( 'inspiry_news_description', array(
			'label'    => esc_html__( 'Description', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_news',
			'settings' => 'inspiry_news_description',
			'type'     => 'textarea'
		) );

		// number of news posts
		$wp_customize->add_setting( 'inspiry_news_posts_number', array(
			'default'           => 3,
			'sanitize_callback' => 'inspiry_sanitize'
		) );

		$wp_customize->add_control(
			new Inspiry_Dropdown_Control(
				$wp_customize,
				'inspiry_news_posts_number',
				array(
					'label'       => esc_html__( 'Number of Blog Posts', 'inspiry-tourpress' ),
					'description' => esc_html__( 'Select a number of blog posts you want to display.', 'inspiry-tourpress' ),
					'section'     => 'inspiry_home_news',
					'settings'    => 'inspiry_news_posts_number',
					'choices'     => array(
						3   => esc_html__( '3', 'inspiry-tourpress' ),
						6   => esc_html__( '6', 'inspiry-tourpress' ),
						9   => esc_html__( '9', 'inspiry-tourpress' ),
						- 1 => esc_html__( 'All', 'inspiry-tourpress' ),
					)
				)
			)
		);

		// news posts type
		$wp_customize->add_setting( 'inspiry_news_posts_type', array(
			'default'           => 'recent',
			'sanitize_callback' => 'inspiry_sanitize'
		) );

		$wp_customize->add_control(
			new Inspiry_Dropdown_Control(
				$wp_customize,
				'inspiry_news_posts_type',
				array(
					'label'       => esc_html__( 'Blog Posts From', 'inspiry-tourpress' ),
					'description' => esc_html__( 'Select an option you want to display blog posts from.', 'inspiry-tourpress' ),
					'section'     => 'inspiry_home_news',
					'settings'    => 'inspiry_news_posts_type',
					'choices'     => array(
						'recent'   => esc_html__( 'Recent', 'inspiry-tourpress' ),
						'random'   => esc_html__( 'Random', 'inspiry-tourpress' ),
						'taxonomy' => esc_html__( 'Categories & Tags', 'inspiry-tourpress' ),
					)
				)
			)
		);

		// generate categories list array
		$categories = get_categories( array(
			'orderby'    => 'name',
			'order'      => 'ASC',
			'hide_empty' => true
		) );

		foreach ( $categories as $category ) {
			$categories_list[ $category->term_id ] = $category->name;
		}

		// blog categories
		$wp_customize->add_setting( 'inspiry_home_news_categories', array(
			'sanitize_callback' => 'inspiry_sanitize'
		) );
		$wp_customize->add_control( new Inspiry_Multiple_Checkbox_Customize_Control (
			$wp_customize,
			'inspiry_home_news_categories',
			array(
				'label'           => esc_html__( 'Categories', 'inspiry-tourpress' ),
				'settings'        => 'inspiry_home_news_categories',
				'section'         => 'inspiry_home_news',
				'choices'         => $categories_list,
				'active_callback' => 'inspiry_news_posts_type'
			)
		) );

		// generate tags list array
		$terms_list = array();

		$terms = get_terms( 'post_tag', array(
			'hide_empty' => true,
		) );

		foreach ( $terms as $term ) {
			$terms_list[ $term->term_id ] = $term->name;
		}

		// blog categories
		$wp_customize->add_setting( 'inspiry_home_news_tags', array(
			'sanitize_callback' => 'inspiry_sanitize'
		) );
		$wp_customize->add_control( new Inspiry_Multiple_Checkbox_Customize_Control (
			$wp_customize,
			'inspiry_home_news_tags',
			array(
				'label'           => esc_html__( 'Tags', 'inspiry-tourpress' ),
				'settings'        => 'inspiry_home_news_tags',
				'section'         => 'inspiry_home_news',
				'choices'         => $terms_list,
				'active_callback' => 'inspiry_news_posts_type'
			)
		) );

	}

	add_action( 'customize_register', 'inspiry_home_news' );
endif;

if ( ! function_exists( 'inspiry_news_posts_type' ) ) :
	/**
	 * Check blog posts type
	 * @return bool
	 */
	function inspiry_news_posts_type( $control ) {

		$posts_type = $control->manager->get_setting( 'inspiry_news_posts_type' )->value();

		if ( $posts_type == 'taxonomy' ) {
			return true;
		}

		return false;
	}
endif;