<?php
/**
 * Customizer settings for Home Destination By Mood
 */

if ( ! function_exists( 'inspiry_home_mood_destinations' ) ) :
	function inspiry_home_mood_destinations( WP_Customize_Manager $wp_customize ) {

		/**
		 * Features Panel
		 */
		$wp_customize->add_section( 'inspiry_home_mood_destinations', array(
			'title'    => esc_html__( 'Destination By Mood', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_home_panel',
			'priority' => 160
		) );

		// features title
		$wp_customize->add_setting( 'inspiry_mood_destinations_title', array(
			'default'           => esc_html__( 'Select your Destination by Mood', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_control( 'inspiry_mood_destinations_title', array(
			'label'    => esc_html__( 'Title', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_mood_destinations',
			'settings' => 'inspiry_mood_destinations_title',
			'type'     => 'text'
		) );

		// features description
		$wp_customize->add_setting( 'inspiry_mood_destinations_description', array(
			'sanitize_callback' => 'wp_kses_post'
		) );

		$wp_customize->add_control( 'inspiry_mood_destinations_description', array(
			'label'    => esc_html__( 'Description', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_mood_destinations',
			'settings' => 'inspiry_mood_destinations_description',
			'type'     => 'textarea'
		) );

		// Registers destinations by mood background image settings
		$wp_customize->add_setting( 'inspiry_md_background_image_url', array(
			'sanitize_callback' => 'esc_url'
		) );

		$wp_customize->add_setting( 'inspiry_md_background_image_id', array(
			'sanitize_callback' => 'absint'
		) );

		$wp_customize->add_setting( 'inspiry_md_background_repeat', array(
			'default'           => 'no-repeat',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'inspiry_md_background_size', array(
			'default'           => 'auto',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'inspiry_md_background_position', array(
			'default'           => 'center-center',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		// Registers inspiry_md_background control
		$wp_customize->add_control(
			new Customize_Custom_Background_Control(
				$wp_customize,
				'inspiry_md_background',
				array(
					'label'    => esc_html__( 'Background Image', 'inspiry-tourpress' ),
					'section'  => 'inspiry_home_mood_destinations',
					'settings' => array(
						'image_url' => 'inspiry_md_background_image_url',
						'image_id'  => 'inspiry_md_background_image_id',
						'repeat'    => 'inspiry_md_background_repeat', // Use false to hide the field
						'size'      => 'inspiry_md_background_size',
						'position'  => 'inspiry_md_background_position'
					)
				)
			)
		);

		$wp_customize->add_setting( 'inspiry_md_background_color', array(
			'default'           => '#DFF6FF',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize, // WP_Customize_Manager
				'inspiry_md_background_color', // Setting id
				array( // Args, including any custom ones.
					'label'    => esc_html__( 'Background Color', 'inspiry-tourpress' ),
					'section'  => 'inspiry_home_mood_destinations',
					'settings' => 'inspiry_md_background_color'
				)
			)
		);

	}

	add_action( 'customize_register', 'inspiry_home_mood_destinations' );
endif;
