<?php
/**
 * Customizer settings for Home Featured Packages
 */

if ( ! function_exists( 'inspiry_home_featured_pack' ) ) :
	function inspiry_home_featured_pack( WP_Customize_Manager $wp_customize ) {

		/**
		 * Feature Panel
		 */
		$wp_customize->add_section( 'inspiry_home_featured_pack', array(
			'title'    => esc_html__( 'Featured Packages', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_home_panel',
			'priority' => 160
		) );

		// features title
		$wp_customize->add_setting( 'inspiry_featured_pack_title', array(
			'default'           => esc_html__( 'Featured Packages', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_control( 'inspiry_featured_pack_title', array(
			'label'    => esc_html__( 'Title', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_featured_pack',
			'settings' => 'inspiry_featured_pack_title',
			'type'     => 'text'
		) );

		// features description
		$wp_customize->add_setting( 'inspiry_featured_pack_description', array(
			'sanitize_callback' => 'wp_kses_post'
		) );

		$wp_customize->add_control( 'inspiry_featured_pack_description', array(
			'label'    => esc_html__( 'Description', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_featured_pack',
			'settings' => 'inspiry_featured_pack_description',
			'type'     => 'textarea'
		) );

		// number of featured tours
		$wp_customize->add_setting( 'inspiry_featured_pack_tours', array(
			'default'           => 3,
			'sanitize_callback' => 'inspiry_sanitize'
		) );

		$wp_customize->add_control(
			new Inspiry_Dropdown_Control(
				$wp_customize,
				'inspiry_featured_pack_tours',
				array(
					'label'       => esc_html__( 'Number of Featured Tours', 'inspiry-tourpress' ),
					'description' => esc_html__( 'Select a number of featured tours you want to display.', 'inspiry-tourpress' ),
					'section'     => 'inspiry_home_featured_pack',
					'settings'    => 'inspiry_featured_pack_tours',
					'choices'     => array(
						3   => esc_html__( '3', 'inspiry-tourpress' ),
						6   => esc_html__( '6', 'inspiry-tourpress' ),
						9   => esc_html__( '9', 'inspiry-tourpress' ),
						- 1 => esc_html__( 'All', 'inspiry-tourpress' ),
					)
				)
			)
		);

	}

	add_action( 'customize_register', 'inspiry_home_featured_pack' );
endif;
