<?php
/**
 * Customizer settings for Home Explore Tours
 */

if ( ! function_exists( 'inspiry_home_explore_tours' ) ) :
	function inspiry_home_explore_tours( WP_Customize_Manager $wp_customize ) {

		/**
		 * Explore Tours Panel
		 */
		$wp_customize->add_section( 'inspiry_home_explore_tours', array(
			'title'    => esc_html__( 'Explore Tours', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_home_panel',
			'priority' => 160
		) );

		// explore tours title
		$wp_customize->add_setting( 'inspiry_explore_tours_title', array(
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_control( 'inspiry_explore_tours_title', array(
			'label'    => esc_html__( 'Title', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_explore_tours',
			'settings' => 'inspiry_explore_tours_title',
			'type'     => 'text'
		) );

		// explore tours description
		$wp_customize->add_setting( 'inspiry_explore_tours_description', array(
			'sanitize_callback' => 'wp_kses_post'
		) );

		$wp_customize->add_control( 'inspiry_explore_tours_description', array(
			'label'    => esc_html__( 'Description', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_explore_tours',
			'settings' => 'inspiry_explore_tours_description',
			'type'     => 'textarea'
		) );

		// explore tours button text
		$wp_customize->add_setting( 'inspiry_explore_tours_btn', array(
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_control( 'inspiry_explore_tours_btn', array(
			'label'    => esc_html__( 'Button Text', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_explore_tours',
			'settings' => 'inspiry_explore_tours_btn',
			'type'     => 'text'
		) );

		// explore tours button url
		$wp_customize->add_setting( 'inspiry_explore_tours_url', array(
			'sanitize_callback' => 'esc_url'
		) );

		$wp_customize->add_control( 'inspiry_explore_tours_url', array(
			'label'    => esc_html__( 'Button URL', 'inspiry-tourpress' ),
			'section'  => 'inspiry_home_explore_tours',
			'settings' => 'inspiry_explore_tours_url',
			'type'     => 'url'
		) );

		/* Separator */
		$wp_customize->add_setting( 'inspiry_explore_tours_url_separator', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'inspiry_explore_tours_url_separator',
				array(
					'section' => 'inspiry_home_explore_tours',
				)
			)
		);

		// Registers explore tours background image settings
		$wp_customize->add_setting( 'inspiry_et_background_image_url', array(
			'sanitize_callback' => 'esc_url'
		) );

		$wp_customize->add_setting( 'inspiry_et_background_image_id', array(
			'sanitize_callback' => 'absint'
		) );

		$wp_customize->add_setting( 'inspiry_et_background_repeat', array(
			'default'           => 'no-repeat',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'inspiry_et_background_size', array(
			'default'           => 'auto',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_setting( 'inspiry_et_background_position', array(
			'default'           => 'center-center',
			'sanitize_callback' => 'sanitize_text_field'
		) );

		// Registers inspiry_et_background control
		$wp_customize->add_control(
			new Customize_Custom_Background_Control(
				$wp_customize,
				'inspiry_et_background',
				array(
					'label'    => esc_html__( 'Background Image', 'inspiry-tourpress' ),
					'section'  => 'inspiry_home_explore_tours',
					// Tie a setting (defined via `$wp_customize->add_setting()`) to the control.
					'settings' => array(
						'image_url' => 'inspiry_et_background_image_url',
						'image_id'  => 'inspiry_et_background_image_id',
						'repeat'    => 'inspiry_et_background_repeat', // Use false to hide the field
						'size'      => 'inspiry_et_background_size',
						'position'  => 'inspiry_et_background_position'
					)
				)
			)
		);

	}

	add_action( 'customize_register', 'inspiry_home_explore_tours' );
endif;