<?php
/**
 * Customizer settings for Header
 */

if ( ! function_exists( 'inspiry_header_customizer' ) ) :
	function inspiry_header_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Site Identity ( retina logo )
		 */
		$wp_customize->add_setting( 'inspiry_site_logo_retina', array(
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'theme_sitelogo_retina', array(
			'label'       => esc_html__( 'Retina Logo', 'inspiry-tourpress' ),
			'description' => esc_html__( 'Upload double size of your default logo image. For example, if your default logo image size is 185px by 24px then your retina logo image size should be 370px by 48px.', 'inspiry-tourpress' ),
			'section'     => 'title_tagline',
			'settings'    => 'inspiry_site_logo_retina',
			'priority'    => 8,
		) ) );

		/**
		 * Header Topbar Panel
		 */
		$wp_customize->add_panel(
			'inspiry_header_panel',
			array(
				'title' => esc_html__( 'Header', 'inspiry-tourpress' ),
			)
		);

		/**
		 * Header Topbar Section
		 */
		$wp_customize->add_section( 'inspiry_header_topbar_section', array(
			'title'    => esc_html__( 'Topbar', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_header_panel',
			'priority' => 160,
		) );

		/**
		 * Header Banner Section
		 */
		$wp_customize->add_section( 'inspiry_header_banner_section', array(
			'title'    => esc_html__( 'Banner', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_header_panel',
			'priority' => 165,
		) );

		/**
		 * Header Others Section
		 */
		$wp_customize->add_section( 'inspiry_header_others_section', array(
			'title'    => esc_html__( 'Others', 'inspiry-tourpress' ),
			'panel'    => 'inspiry_header_panel',
			'priority' => 170,
		) );



		// topbar display
		$wp_customize->add_setting( 'inspiry_header_top_bar', array(
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize',
		) );

		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_header_top_bar',
			array(
				'label'    => esc_html__( 'Topbar Above Header', 'inspiry-tourpress' ),
				'section'  => 'inspiry_header_topbar_section',
				'settings' => 'inspiry_header_top_bar',
				'choices'  => array(
					'show' => 'Show',
					'hide' => 'Hide',
				),
			)
		) );

		// chose what to display menu or welcome note
		$wp_customize->add_setting( 'inspiry_header_topbar_left_slot', array(
			'default'           => 'note',
			'sanitize_callback' => 'inspiry_sanitize',
		) );

		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_header_topbar_left_slot',
			array(
				'label'       => esc_html__( 'Topbar Left Slot', 'inspiry-tourpress' ),
				'section'     => 'inspiry_header_topbar_section',
				'settings'    => 'inspiry_header_topbar_left_slot',
				'description' => esc_html__( 'Please choose what to display in the left slot of topbar.', 'inspiry-tourpress' ),
				'choices'     => array(
					'menu' => esc_html__( 'Topbar Menu', 'inspiry-tourpress' ),
					'note' => esc_html__( 'Welcome Note', 'inspiry-tourpress' ),
				),
			)
		) );

		// welcome note
		$wp_customize->add_setting( 'inspiry_topbar_note', array(
			'default'           => esc_html__( 'Welcome!', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'inspiry_topbar_note', array(
			'label'           => esc_html__( 'Welcome Note Text', 'inspiry-tourpress' ),
			'section'         => 'inspiry_header_topbar_section',
			'settings'        => 'inspiry_topbar_note',
			'type'            => 'text',
			'active_callback' => 'inspiry_topbar_left_slot',
		) );

		// topbar email
		$wp_customize->add_setting( 'inspiry_topbar_email', array(
			'default'           => esc_html__( 'info@example.com', 'inspiry-tourpress' ),
			'sanitize_callback' => 'sanitize_email',
		) );

		$wp_customize->add_control( 'inspiry_topbar_email', array(
			'label'    => esc_html__( 'Topbar Email', 'inspiry-tourpress' ),
			'section'  => 'inspiry_header_topbar_section',
			'settings' => 'inspiry_topbar_email',
			'type'     => 'text',
		) );

		// separator
		$wp_customize->add_setting( 'inspiry_topbar_email_separator', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'inspiry_topbar_email_separator',
				array(
					'section' => 'inspiry_header_topbar_section',
				)
			)
		);

		// twitter url
		$wp_customize->add_setting( 'inspiry_topbar_twitter', array(
			'sanitize_callback' => 'esc_url',
		) );

		$wp_customize->add_control( 'inspiry_topbar_twitter', array(
			'label'    => esc_html__( 'Twitter URL', 'inspiry-tourpress' ),
			'section'  => 'inspiry_header_topbar_section',
			'settings' => 'inspiry_topbar_twitter',
			'type'     => 'text',
		) );

		// facebook url
		$wp_customize->add_setting( 'inspiry_topbar_facebook', array(
			'sanitize_callback' => 'esc_url',
		) );

		$wp_customize->add_control( 'inspiry_topbar_facebook', array(
			'label'    => esc_html__( 'Facebook URL', 'inspiry-tourpress' ),
			'section'  => 'inspiry_header_topbar_section',
			'settings' => 'inspiry_topbar_facebook',
			'type'     => 'text',
		) );

		// google plus url
		$wp_customize->add_setting( 'inspiry_topbar_google', array(
			'sanitize_callback' => 'esc_url',
		) );

		$wp_customize->add_control( 'inspiry_topbar_google', array(
			'label'    => esc_html__( 'Google+ URL', 'inspiry-tourpress' ),
			'section'  => 'inspiry_header_topbar_section',
			'settings' => 'inspiry_topbar_google',
			'type'     => 'text',
		) );

		// youtube url
		$wp_customize->add_setting( 'inspiry_topbar_youtube', array(
			'sanitize_callback' => 'esc_url',
		) );

		$wp_customize->add_control( 'inspiry_topbar_youtube', array(
			'label'    => esc_html__( 'YouTube URL', 'inspiry-tourpress' ),
			'section'  => 'inspiry_header_topbar_section',
			'settings' => 'inspiry_topbar_youtube',
			'type'     => 'text',
		) );

		// instagram url
		$wp_customize->add_setting( 'inspiry_topbar_instagram', array(
			'sanitize_callback' => 'esc_url',
		) );

		$wp_customize->add_control( 'inspiry_topbar_instagram', array(
			'label'    => esc_html__( 'Instagram URL', 'inspiry-tourpress' ),
			'section'  => 'inspiry_header_topbar_section',
			'settings' => 'inspiry_topbar_instagram',
			'type'     => 'text',
		) );

		// separator
		$wp_customize->add_setting( 'inspiry_topbar_woo_icon_separator', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'inspiry_topbar_woo_icon_separator',
				array(
					'section' => 'inspiry_header_topbar_section',
				)
			)
		);

		if( is_woocommerce_activated() ) {

			// woocommerce icon
			$wp_customize->add_setting( 'inspiry_topbar_woo_icon', array(
				'default'           => 'show',
				'sanitize_callback' => 'inspiry_sanitize',
			) );

			$wp_customize->add_control( new Inspiry_Dropdown_Control(
				$wp_customize,
				'inspiry_topbar_woo_icon',
				array(
					'label'    => esc_html__( 'WooCommerce Cart Icon', 'inspiry-tourpress' ),
					'section'  => 'inspiry_header_topbar_section',
					'settings' => 'inspiry_topbar_woo_icon',
					'choices'  => array(
						'show' => 'Show',
						'hide' => 'Hide',
					),
				)
			) );
		}

		// header phone number
		$wp_customize->add_setting( 'inspiry_header_phone', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'inspiry_header_phone', array(
			'label'    => esc_html__( 'Header Phone', 'inspiry-tourpress' ),
			'section'  => 'inspiry_header_others_section',
			'settings' => 'inspiry_header_phone',
			'type'     => 'text',
		) );

		// Sticky Header
		$wp_customize->add_setting( 'inspiry_sticky_header', array(
			'default'           => 'disable',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'inspiry_sticky_header', array(
			'label'    => esc_html__( 'Sticky Header', 'inspiry-tourpress' ),
			'section'  => 'inspiry_header_others_section',
			'settings' => 'inspiry_sticky_header',
			'type'     => 'radio',
			'choices'  => array(
				'enable'  => esc_html__( 'Enable', 'inspiry-tourpress' ),
				'disable' => esc_html__( 'Disable', 'inspiry-tourpress' ),
			)
		) );

		// Registers header banner background image settings
		$wp_customize->add_setting( 'inspiry_banner_image_url', array(
			'sanitize_callback' => 'esc_url',
		) );

		$wp_customize->add_setting( 'inspiry_banner_image_id', array(
			'sanitize_callback' => 'absint',
		) );

		$wp_customize->add_setting( 'inspiry_banner_repeat', array(
			'default'           => 'no-repeat',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_setting( 'inspiry_banner_size', array(
			'default'           => 'cover',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_setting( 'inspiry_banner_position', array(
			'default'           => 'center-center',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		// banner image
		$wp_customize->add_control(
			new Customize_Custom_Background_Control(
				$wp_customize,
				'inspiry_banner_image',
				array(
					'label'       => esc_html__( 'Banner Background Image', 'inspiry-tourpress' ),
					'description' => esc_html__( 'Required minimum width is 2000px and minimum height is 295px.', 'inspiry-tourpress' ),
					'section'     => 'inspiry_header_banner_section',
					'settings'    => array(
						'image_url' => 'inspiry_banner_image_url',
						'image_id'  => 'inspiry_banner_image_id',
						'repeat'    => 'inspiry_banner_repeat', // Use false to hide the field
						'size'      => 'inspiry_banner_size',
						'position'  => 'inspiry_banner_position',
					),
				)
			)
		);

		// separator
		$wp_customize->add_setting( 'inspiry_banner_image_separator', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'inspiry_banner_image_separator',
				array(
					'section' => 'inspiry_header_banner_section',
				)
			)
		);

		// bread crumbs on banner image
		$wp_customize->add_setting( 'inspiry_banner_bread_crumbs', array(
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize',
		) );

		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_banner_bread_crumbs',
			array(
				'label'    => esc_html__( 'Bread Crumbs on Banner Image', 'inspiry-tourpress' ),
				'section'  => 'inspiry_header_banner_section',
				'settings' => 'inspiry_banner_bread_crumbs',
				'choices'  => array(
					'show' => 'Show',
					'hide' => 'Hide',
				),
			)
		) );

		// page title on banner image
		$wp_customize->add_setting( 'inspiry_banner_page_title', array(
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize',
		) );

		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_banner_page_title',
			array(
				'label'    => esc_html__( 'Page Title on Banner Image', 'inspiry-tourpress' ),
				'section'  => 'inspiry_header_banner_section',
				'settings' => 'inspiry_banner_page_title',
				'choices'  => array(
					'show' => 'Show',
					'hide' => 'Hide',
				),
			)
		) );

	}

	add_action( 'customize_register', 'inspiry_header_customizer' );
endif;

if ( ! function_exists( 'inspiry_topbar_left_slot' ) ) :
	/**
	 * Check Topbar left slot
	 * @return bool
	 */
	function inspiry_topbar_left_slot( $control ) {

		$topbar_slot = $control->manager->get_setting( 'inspiry_header_topbar_left_slot' )->value();
		$control_id  = $control->id;

		if ( 'inspiry_topbar_note' === $control_id && 'note' == $topbar_slot ) {
			return true;
		}
		if ( 'inspiry_topbar_menu' == $control_id && 'menu' == $topbar_slot ) {
			return true;
		}

		return false;
	}
endif;
