<?php
/**
 * Customizer settings for Footer
 */

if ( ! function_exists( 'inspiry_footer_customizer_settings' ) ) :
	function inspiry_footer_customizer_settings( WP_Customize_Manager $wp_customize ) {

		/**
		 * Footer Panel
		 */
		$wp_customize->add_section( 'inspiry_footer_section', array(
			'title'    => esc_html__( 'Footer', 'inspiry-tourpress' ),
			'priority' => 195,
		) );

		// footer socket
		$wp_customize->add_setting( 'inspiry_footer_socket', array(
			'default'           => 'show',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( new Inspiry_Dropdown_Control(
			$wp_customize,
			'inspiry_footer_socket',
			array(
				'label'    => esc_html__( 'Bottom Socket', 'inspiry-tourpress' ),
				'section'  => 'inspiry_footer_section',
				'settings' => 'inspiry_footer_socket',
				'choices'  => array(
					'show' => esc_html__( 'Show', 'inspiry-tourpress' ),
					'hide' => esc_html__( 'Hide', 'inspiry-tourpress' ),
				),
			)
		) );

		// copyright text
		$inspiry_footer_copyright = sprintf( __( "&copy; Copyright %s <a href='%s'>%s</a> - All Right Reserved.", 'inspiry-tourpress' ), date( 'Y' ), get_site_url(), get_bloginfo( 'name' ) ) ;
		$wp_customize->add_setting( 'inspiry_footer_copyright', array(
			'sanitize_callback' => 'wp_kses_post',
			'default'           => wp_kses( $inspiry_footer_copyright, inspiry_allowed_tags()),
		) );

		$wp_customize->add_control(
			'inspiry_footer_copyright',
			array(
				'label'       => esc_html__( 'Copyright Text', 'inspiry-tourpress' ),
				'description' => esc_html__( 'You can use the (a, strong, em, br and i) tags in the following text area. ', 'inspiry-tourpress' ),
				'section'     => 'inspiry_footer_section',
				'settings'    => 'inspiry_footer_copyright',
				'type'        => 'textarea',
			) );

		// separator
		$wp_customize->add_setting( 'inspiry_footer_payments_separator', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );
		$wp_customize->add_control(
			new Inspiry_Separator_Control(
				$wp_customize,
				'inspiry_footer_payments_separator',
				array(
					'section' => 'inspiry_footer_section',
				)
			)
		);

		// accepted payment methods
		$wp_customize->add_setting( 'inspiry_footer_payments', array(
			'sanitize_callback' => 'inspiry_sanitize',
		) );

		$wp_customize->add_control( new Inspiry_Multiple_Checkbox_Customize_Control(
			$wp_customize,
			'inspiry_footer_payments',
			array(
				'label'    => esc_html__( 'Accepted Payment Methods', 'inspiry-tourpress' ),
				'settings' => 'inspiry_footer_payments',
				'section'  => 'inspiry_footer_section',
				'choices'  => array(
					'visa'       => esc_html__( 'Visa Card', 'inspiry-tourpress' ),
					'amex'       => esc_html__( 'American Card', 'inspiry-tourpress' ),
					'paypal'     => esc_html__( 'PayPal', 'inspiry-tourpress' ),
					'mastercard' => esc_html__( 'Master Card', 'inspiry-tourpress' ),
				),
			)
		) );
	}

	add_action( 'customize_register', 'inspiry_footer_customizer_settings' );
endif;
