<?php
/**
 * Customizer
 */

if ( ! function_exists( 'inspiry_sanitize' ) ) :
	/**
	 * Default sanitize function to use where no sanitization needed.
	 * It's to fulfil sanitization function requirement while adding a
	 * customizer setting.
	 *
	 * @param Mixed
	 *
	 * @return Mixed
	 */
	function inspiry_sanitize( $value ) {
		return $value;
	}
endif;

/**
 * Custom Intro Text Control
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/custom-controls/control-intro-text.php' );

/**
 * Custom Dropdown Control
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/custom-controls/control-dropdown.php' );

/**
 * Custom Separator Control
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/custom-controls/control-separator.php' );

/**
 * Custom Dragdrop Control
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/custom-controls/control-dragdrop.php' );

/**
 * Custom multiple checkbox Control
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/custom-controls/control-multiple-checkbox.php' );

/**
 * Custom Range Control
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/custom-controls/control-range.php' );


/**
 * Register customizer panels, sections, settings, and controls.
 *
 * @since  1.0.0
 * @access public
 *
 * @param  object $wp_customize
 *
 * @return void
 */
function background_image_customize_register( $wp_customize ) {

	// Load customizer background control class.
	require_once( INSPIRY_INC_DIRECTORY . 'customizer/custom-controls/control-custom-background-image.php' );

	// Register background control JS template.
	$wp_customize->register_control_type( 'Customize_Custom_Background_Control' );

	// Add Sections, Panels, Settings, and Controls Here

}

add_action( 'customize_register', 'background_image_customize_register' );

/**
 * Styles Settings
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/styles.php' );

/**
 * Header Settings
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/header.php' );

/**
 * Home Settings
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/home.php' );

/**
 * Tour Detail Page Settings
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/tour-detail.php' );

/**
 * Search Page Settings
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/tour-search.php' );

/**
 * Taxonomy & Archive Settings
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/taxonomy-archives.php' );

/**
 * Misc Settings
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/misc.php' );

/**
 * Footer Settings
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/footer.php' );

/**
 * WooCommerce Settings
 */
if ( class_exists( 'woocommerce' ) ) {
	require_once( INSPIRY_INC_DIRECTORY . 'customizer/theme-settings/woocommerce.php' );
}
