<?php
if ( ! class_exists( 'WP_Customize_Range_Control' ) ) {
	return null;
}

class WP_Customize_Range_Control extends WP_Customize_Control {
	public $type = 'custom_range';

	public function enqueue() {
		wp_enqueue_script(
			'cs-range-control',
			get_template_directory_uri() . '/inc/customizer/custom-controls/js/range-control.js',
			array( 'jquery' ),
			false,
			true
		);
	}

	public function render_content() {
		?>
		<label>
			<?php if ( ! empty( $this->label ) ) : ?>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
			<?php endif; ?>
			<div class="cs-range-value"><?php echo esc_attr( $this->value() ); ?>px</div>
			<input data-input-type="range" type="range" <?php $this->input_attrs(); ?> value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); ?> />
			<?php if ( ! empty( $this->description ) ) : ?>
				<span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
			<?php endif; ?>
		</label>
		<?php
	}
}