<?php
if ( ! class_exists( 'Inspiry_Dragdrop_Control' ) ) {
	return null;
}

/**
 * Class Inspiry_Dragdrop_Control
 *
 * Custom control to display separator
 */
class Inspiry_Dragdrop_Control extends WP_Customize_Control {
	/**
	 * Render customizer drag & drop field html
	 */
	public function render_content() {
		$ordered_sections = $this->sections_ordered_array();
		?>
		<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
		<span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
		<div class="sections">
			<?php
				foreach ( $ordered_sections as $key => $value ) {
					echo '<div class="section" draggable="true" ><span data-value="' . esc_attr( $key ) . '">' . esc_html( $value ) . '</span></div>';
				}
			?>
		</div>
		<input class="sorting-db" type="text" <?php $this->link(); ?>>
		<?php
	}

	public function enqueue() {

		// drag & drop customizer control css
		wp_enqueue_style(
			'customizer-dragdrop',
			INSPIRY_INC_DIRECTORY_URI . 'customizer/custom-controls/css/dragdrop.css'
		);

		// drag & drop customizer control js
		wp_enqueue_script(
			'customizer-dragdrop',
			INSPIRY_INC_DIRECTORY_URI . 'customizer/custom-controls/js/dragdrop.js',
			array( 'jquery' ),
			false,
			true
		);
	}

	public function sections_ordered_array() {

		$saved_order    = explode( ',', $this->value() );
		$sections_order = $this->clean_ordered_array( $saved_order, $this->choices );

		return array_merge( array_flip( $sections_order ), $this->choices );
	}

	/**
	 * @param $order
	 * @param $choices
	 *
	 * @return array
	 */
	public function clean_ordered_array( $order, $choices ) {

		$sections_order = array();

		foreach ( $order as $section ) {
			if ( array_key_exists( $section, $choices ) ) {
				$sections_order[] = $section;
			}
		}

		return $sections_order;
	}
}