<?php
/**
 * The current version of TourPress theme.
 */
define( 'INSPIRY_THEME_VERSION', '1.1.8' );

define( 'INPIRY_TEMPLATE_DIRECTORY_URI', get_template_directory_uri() . '/' );
define( 'INSPIRY_JS_DIRECTORY_URI', INPIRY_TEMPLATE_DIRECTORY_URI . 'js/' );
define( 'INSPIRY_CSS_DIRECTORY_URI', INPIRY_TEMPLATE_DIRECTORY_URI . 'css/' );
define( 'INSPIRY_INC_DIRECTORY_URI', INPIRY_TEMPLATE_DIRECTORY_URI . 'inc/' );

define( 'INPIRY_TEMPLATE_DIRECTORY', get_template_directory() . '/' );
define( 'INSPIRY_JS_DIRECTORY', INPIRY_TEMPLATE_DIRECTORY . 'js/' );
define( 'INSPIRY_CSS_DIRECTORY', INPIRY_TEMPLATE_DIRECTORY . 'css/' );
define( 'INSPIRY_INC_DIRECTORY', INPIRY_TEMPLATE_DIRECTORY . 'inc/' );

if ( ! function_exists( 'inspiry_allowed_tags' ) ) {
	/**
	 * Set allowed html tags in this theme
	 * @return array
	 */
	function inspiry_allowed_tags() {
		$tags = array(
			'a'      => array(
				'href'   => array(),
				'title'  => array(),
				'target' => array(),
			),
			'em'     => array(),
			'strong' => array(),
			'br'     => array(),
			'i'      => array(
				'class' => array(),
			),
		);

		return $tags;
	}
}

/**
 * Theme Plugins
 */
require_once INSPIRY_INC_DIRECTORY . 'tgm/install-plugins.php';

/**
 * Theme Functions
 */
require_once INSPIRY_INC_DIRECTORY . 'functions/functions.php';

/**
 * Theme MetaBoxes
 */
require_once INSPIRY_INC_DIRECTORY . 'meta-box/pages-meta-boxes.php';

/**
 * Demo contents import
 */
require_once INSPIRY_INC_DIRECTORY . 'demo-import/demo-import.php';

/**
 * Customizer Settings
 */
require_once( INSPIRY_INC_DIRECTORY . 'customizer/customizer.php' );

/**
 * Dynamic CSS
 */
include_once( get_template_directory() . '/css/dynamic-css.php' );

/**
 * General Theme Functions
 */
if ( ! function_exists( 'inspiry_tourpress_setup' ) ) {
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function inspiry_tourpress_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 */
		load_theme_textdomain( 'inspiry-tourpress', get_template_directory() . '/languages' );

		// Set the default content width.
		$GLOBALS['content_width'] = 690;

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );

		add_theme_support( 'custom-logo' );

		/*
		 * Enable support for WooCommerce in this theme.
		 *
		 * @link https://docs.woocommerce.com/document/declare-woocommerce-support-in-third-party-theme/
		 */
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		/*
		 * Used on:
		 * Single post page and Post archive pages
		 */
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 1500, 600, true );

		/*
		 * Add image sizes
		*/
		add_image_size( 'inspiry_image_size_526_406', 526, 406, true ); // special offers (tours)
		add_image_size( 'inspiry_image_size_440_312', 440, 312, true ); // tour gallery
		add_image_size( 'inspiry_image_size_720_560', 720, 560, true ); // blog listing, tour listing and tour gallery
		add_image_size( 'inspiry_image_size_330_404', 330, 404, true ); // for the homepage mood destinations

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'topbar-menu' => esc_html__( 'Topbar Menu', 'inspiry-tourpress' ),
			'header-menu' => esc_html__( 'Header Menu', 'inspiry-tourpress' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'inspiry_tourpress_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

        // Block Style support for Posts.
		add_theme_support( 'wp-block-styles' );

        // Block Style Align Wide support for Posts.
		add_theme_support( 'align-wide' );

		// Add support for responsive embeds.
		add_theme_support( 'responsive-embeds' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Enqueue editor styles.
		add_editor_style( array( inspiry_google_fonts(), get_template_directory_uri() . '/css/editor-style.css' ) );
	}

	add_action( 'after_setup_theme', 'inspiry_tourpress_setup' );
}

if ( ! function_exists( 'inspiry_content_width' ) ) {
	/**
	 * Set the content width in pixels, based on the theme's design and stylesheet.
	 *
	 * Priority 0 to make it available to lower priority callbacks.
	 *
	 * @global int $content_width
	 */
	function inspiry_content_width() {

		$content_width = $GLOBALS['content_width'];

		if ( is_page_template( 'page-templates/fullwidth.php' ) ) {
			$content_width = 1090;
		}
		
		$GLOBALS['content_width'] = apply_filters( 'inspiry_content_width', $content_width );
	}

	add_action( 'template_redirect', 'inspiry_content_width', 0 );
}

if ( ! function_exists( 'inspiry_google_fonts' ) ) {
	/**
	 * Google fonts enqueue url
	 * @since   1.0.0
	 * @return  string
	 */
	function inspiry_google_fonts() {

		$fonts_url     = '';
		$font_families = array();

		/*
		 * Translators: If there are characters in your language that are not
		 * supported by Rubik, translate this to 'off'. Do not translate
		 * into your own language.
		 */
		$montserrat = esc_html_x( 'on', 'Rubik font: on or off', 'inspiry-tourpress' );

		if ( 'off' !== $montserrat ) {
			$font_families[] = 'Rubik:300,400,500,700';
		}

		if ( $font_families ) {
			$query_args = array(
				'family' => urlencode( implode( '|', $font_families ) ),
				'subset' => urlencode( 'latin,latin-ext' ),
			);

			$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
		}

		return esc_url_raw( $fonts_url );
	}
}

if ( ! function_exists( 'inspiry_get_google_map_api_key' ) ) {
	/**
	 * Get Google Map API Key
	 */
	function inspiry_get_google_map_api_key() {

		$plugin_other_options = get_option( 'easy_tours_others_option' );
		if ( isset( $plugin_other_options['google_maps_api_key'] ) ) {
			return $plugin_other_options['google_maps_api_key'];
		}

		return false;
	}
}

if ( ! function_exists( 'inspiry_enqueue_styles' ) ) :
	/**
	 * Enqueue required styles
	 * @since   1.0.0
	 * @return  void
	 */
	function inspiry_enqueue_styles() {

        if ( ! is_admin() ) {

	        // Google Font
	        wp_enqueue_style(
		        'google-rubik',
		        inspiry_google_fonts(),
		        array(),
		        INSPIRY_THEME_VERSION
	        );

	        // bootstrap
			wp_enqueue_style(
				'bootstrap',
				INSPIRY_CSS_DIRECTORY_URI . 'bootstrap.css',
				array(),
				'4.0.0'
			);

			// fontawesome
			wp_enqueue_style(
				'fontawesome',
				INSPIRY_CSS_DIRECTORY_URI . 'font-awesome.min.css',
				array(),
				'4.7.0'
			);

			// meanmenu
			wp_enqueue_style(
				'meanmenu',
				INSPIRY_JS_DIRECTORY_URI . 'meanmenu/meanmenu.min.css',
				array(),
				'2.0.8'
			);

			// flexslider
			wp_enqueue_style(
				'flexslider',
				INSPIRY_JS_DIRECTORY_URI . 'flexslider/flexslider.css',
				array(),
				'2.7.2'
			);

			// owl carousel
			wp_enqueue_style(
				'owl-carousel',
				INSPIRY_JS_DIRECTORY_URI . 'owl-carousel/owl.carousel.min.css',
				array(),
				'2.2.1'
			);

			// bar rating theme
			wp_enqueue_style(
				'bar-rating-theme',
				INSPIRY_JS_DIRECTORY_URI . 'barrating/fontawesome-stars.css',
				array(),
				'2.6.3'
			);

			// fakeloader
			$loader_display = get_theme_mod( 'inspiry_site_loader_display', 'hide' );
			if ( 'hide' != $loader_display ) {

				wp_enqueue_style(
					'fakeloader',
					INSPIRY_JS_DIRECTORY_URI . 'fakeloader/fakeLoader.css',
					array(),
					'1.1.0'
				);
			}

			// magnific popup
			wp_enqueue_style(
				'magnific-popup',
				INSPIRY_JS_DIRECTORY_URI . 'magnific/magnific-popup.css',
				array(),
				'1.1.0'
			);


			// jquery ui
			wp_enqueue_style(
				'jquery-ui',
				INSPIRY_JS_DIRECTORY_URI . 'jquery-ui/jquery-ui.min.css',
				array(),
				'1.12.1'
			);

			// theme main
			wp_enqueue_style(
				'inspiry-main',
				INSPIRY_CSS_DIRECTORY_URI . 'main.css',
				array(),
				INSPIRY_THEME_VERSION
			);

			wp_add_inline_style( 'inspiry-main', apply_filters( 'tourpress_custom_css', '' ) );

			wp_enqueue_style(
				'tourpress-print-style',
				INSPIRY_CSS_DIRECTORY_URI . 'print.css',
				array(),
				INSPIRY_THEME_VERSION
			);

			// theme css
			wp_enqueue_style(
				'parent-custom',
				INSPIRY_CSS_DIRECTORY_URI . 'custom.css',
				array(),
				INSPIRY_THEME_VERSION
			);

			wp_enqueue_style(
				'tourpress-style',
				get_stylesheet_directory_uri() . '/style.css',
				array(),
				INSPIRY_THEME_VERSION
			);

			// add header banner inline styles after parent custom css file
			$background_repeat   = 'no-repeat';
			$background_size     = 'cover';
			$background_position = 'center-center';

			$background_url = get_theme_mod( 'inspiry_shop_banner_image_url' );

			if ( ( is_woocommerce_activated() && ( is_shop() || is_product() ) ) && ! empty( $background_url ) ) {
				$background_repeat   = get_theme_mod( 'inspiry_shop_banner_repeat', 'no-repeat' );
				$background_size     = get_theme_mod( 'inspiry_shop_banner_size', 'cover' );
				$background_position = get_theme_mod( 'inspiry_shop_banner_position', 'center-center' );
			} else {
				$background_url = get_theme_mod( 'inspiry_banner_image_url' );
				if ( ! empty( $background_url ) ) {
					$background_repeat   = get_theme_mod( 'inspiry_banner_repeat', 'no-repeat' );
					$background_size     = get_theme_mod( 'inspiry_banner_size', 'cover' );
					$background_position = get_theme_mod( 'inspiry_banner_position', 'center-center' );
				}
			}

			$custom_css = "
				#site-banner {
					background-repeat: " . esc_html( $background_repeat ) . ";
					background-size: " . esc_html( $background_size ) . ";
					background-position: " . str_replace( '-', ' ', esc_html( $background_position ) ) . ";
				}
                ";

			wp_add_inline_style( 'parent-custom', $custom_css );

		}

	}

	add_action( 'wp_enqueue_scripts', 'inspiry_enqueue_styles' );

endif; // inspiry_enqueue_styles

if ( ! function_exists( 'inspiry_enqueue_admin_styles' ) ) :
	/**
	 * Enqueue required admin styles
	 * @since   1.0.0
	 * @return  void
	 */
	function inspiry_enqueue_admin_styles() {
		// admin styles
		wp_enqueue_style( 'tourpress-admin', INSPIRY_CSS_DIRECTORY_URI . 'admin.css', array(), INSPIRY_THEME_VERSION );
	}

	add_action( 'admin_enqueue_scripts', 'inspiry_enqueue_admin_styles' );

endif; // inspiry_enqueue_admin_styles

if ( ! function_exists( 'inspiry_enqueue_scripts' ) ) :
	/**
	 * Enqueue required scripts
	 * @since   1.0.0
	 * @return  void
	 */
	function inspiry_enqueue_scripts() {

		if ( ! is_admin() ) :

			// flexslider
			wp_enqueue_script(
				'flexslider',
				INSPIRY_JS_DIRECTORY_URI . 'flexslider/jquery.flexslider-min.js',
				array( 'jquery' ),
				'2.7.2',
				true
			);

			// owl carousel
			wp_enqueue_script(
				'owl-carousel',
				INSPIRY_JS_DIRECTORY_URI . 'owl-carousel/owl.carousel.min.js',
				array( 'jquery' ),
				'2.2.1',
				true
			);

			// meanmenu
			wp_enqueue_script(
				'meanmenu',
				INSPIRY_JS_DIRECTORY_URI . 'meanmenu/jquery.meanmenu.min.js',
				array( 'jquery' ),
				'2.0.8',
				true
			);

			// tether
			wp_enqueue_script(
				'tether',
				INSPIRY_JS_DIRECTORY_URI . 'tether.min.js',
				array( 'jquery' ),
				'1.3.0',
				true
			);

			// bootstrap
			wp_enqueue_script(
				'bootstrap',
				INSPIRY_JS_DIRECTORY_URI . 'bootstrap.min.js',
				array( 'tether' ),
				'4.0.0',
				true
			);

			// nice select
			wp_enqueue_script(
				'nice-select',
				INSPIRY_JS_DIRECTORY_URI . 'jquery.nice-select.min.js',
				array( 'jquery' ),
				'1.0',
				true
			);

			// bar rating
			wp_enqueue_script(
				'bar-rating',
				INSPIRY_JS_DIRECTORY_URI . 'barrating/jquery.barrating.min.js',
				array( 'jquery' ),
				'1.2.1',
				true
			);

			// magnific popup
			wp_enqueue_script(
				'magnific-popup',
				INSPIRY_JS_DIRECTORY_URI . 'magnific/jquery.magnific-popup.min.js',
				array( 'jquery' ),
				'1.1.0',
				true
			);

			// jquery ui datepicker
			wp_enqueue_script('jquery-ui-datepicker');

			// isotope
			wp_enqueue_script(
				'isotope',
				INSPIRY_JS_DIRECTORY_URI . 'isotope.min.js',
				array( 'jquery' ),
				'3.0.6',
				true
			);

			// fakeloader
			$loader_display = get_theme_mod( 'inspiry_site_loader_display', 'hide' );
			if ( 'hide' != $loader_display ) {

				wp_enqueue_script(
					'fakeloader',
					INSPIRY_JS_DIRECTORY_URI . 'fakeloader/fakeLoader.min.js',
					array( 'jquery' ),
					'1.1.0',
					true
				);
			}

			// comment reply
			if ( ! is_admin() && is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
				wp_enqueue_script( 'comment-reply' );
			}

			if ( is_page_template( 'page-templates/contact.php' ) || is_singular( 'tour' ) ) {

				// validate
				wp_enqueue_script(
					'validate',
					INSPIRY_JS_DIRECTORY_URI . 'jquery.validate.min.js',
					array( 'jquery' ),
					'1.15.0',
					true
				);

				// form
				wp_enqueue_script('jquery-form');

				// Get Google Map API Key if available
				$google_map_api_key = inspiry_get_google_map_api_key();

				if ( isset( $google_map_api_key ) && ! empty( $google_map_api_key ) ) {
					$google_map_arguments        = array();
					$google_map_arguments['key'] = urlencode( $google_map_api_key );
					$google_map_api_uri = add_query_arg( apply_filters( 'inspiry_google_map_arguments', $google_map_arguments ), '//maps.google.com/maps/api/js' );

					wp_enqueue_script(
						'google-map-api',
						esc_url_raw( $google_map_api_uri ),
						array(),
						null,
						true
					);
				}
			}

			// register tourpress js
			wp_register_script(
				'tourpress',
				INSPIRY_JS_DIRECTORY_URI . 'tourpress.js',
				array( 'jquery' ),
				INSPIRY_THEME_VERSION,
				true
			);

			// Localize the script with required data
			$localize_array = array();

			if ( is_page_template( 'page-templates/contact.php' ) || is_singular( 'tour' ) ) {

				$meta_data = get_post_custom();

				if ( isset( $meta_data['inspiry_tour_map_location'] ) ) {
					$map_location = explode( ',', $meta_data['inspiry_tour_map_location'][0] );
				} else {
					$map_location = array();
				}

				if ( isset( $map_location[0] )
				     && isset( $map_location[1] )
				     && isset( $map_location[2] )
				) {

					$localize_array['map_lat']  = esc_html( $map_location[0] );
					$localize_array['map_lon']  = esc_html( $map_location[1] );
					$localize_array['map_zoom'] = esc_html( $map_location[2] );
				}

				if ( is_singular( 'tour' ) ) {
					$localize_array['map_container'] = 'tour-map';
				} else {
					$localize_array['map_container'] = 'contact-map';
				}

				$localize_array['map_icon'] = INPIRY_TEMPLATE_DIRECTORY_URI . 'img/svg/map-pin.svg';
			}

			// Sticky Header Customize Option Localization for JS Function.
			$localize_array['inspiry_sticky_header']  = esc_html( get_theme_mod('inspiry_sticky_header') );

			$loader_script = "
				if (jQuery().fakeLoader) {
					$ = jQuery;
					$(document).ready(function(){
						var loader = $('#site-loader'),
							style = loader.data('style'),
							bg = loader.data('bg'),
							icon = loader.data('icon');
			
						if (bg === undefined) {
							bg = '#004274';
						}
			
						$(loader).fakeLoader({
							// timeToHide : 1200,
							zIndex: '9999',
							spinner: style,
							bgColor: bg,
							imagePath: icon
						});
					});
				}
			";

			wp_enqueue_script( 'tourpress' );
			wp_localize_script( 'tourpress', 'localize', $localize_array );
			wp_add_inline_script( 'tourpress', $loader_script );

		endif;

	}

	add_action( 'wp_enqueue_scripts', 'inspiry_enqueue_scripts' );

endif; // inspiry_enqueue_scripts

if ( ! function_exists( 'inspiry_widgets_init' ) ) {
	/**
	 * Register widgets area.
	 */
	function inspiry_widgets_init() {
		register_sidebar( array(
			'name'          => esc_html__( 'Default Sidebar', 'inspiry-tourpress' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add blog and blog detail sidebar widgets here.', 'inspiry-tourpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Pages Sidebar', 'inspiry-tourpress' ),
			'id'            => 'sidebar-page',
			'description'   => esc_html__( 'Add pages sidebar widgets here.', 'inspiry-tourpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Tours Listing Sidebar', 'inspiry-tourpress' ),
			'id'            => 'sidebar-tour',
			'description'   => esc_html__( 'Add tours listing sidebar widgets here.', 'inspiry-tourpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Tours Detail Sidebar', 'inspiry-tourpress' ),
			'id'            => 'sidebar-tour-detail',
			'description'   => esc_html__( 'Add tour detail sidebar widgets here.', 'inspiry-tourpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Contact Sidebar', 'inspiry-tourpress' ),
			'id'            => 'sidebar-contact',
			'description'   => esc_html__( 'Add contact page sidebar widgets here.', 'inspiry-tourpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Footer First Column', 'inspiry-tourpress' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Add footer first column widget here.', 'inspiry-tourpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Footer Second Column', 'inspiry-tourpress' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Add footer second column widget here.', 'inspiry-tourpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Footer Third Column', 'inspiry-tourpress' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Add footer third column widget here.', 'inspiry-tourpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Footer Fourth Column', 'inspiry-tourpress' ),
			'id'            => 'footer-4',
			'description'   => esc_html__( 'Add footer fourth column widget here.', 'inspiry-tourpress' ),
			'before_widget' => '<section id="%1$s" class="widget clearfix %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}

	add_action( 'widgets_init', 'inspiry_widgets_init' );
}

if ( ! function_exists( 'inspiry_pingback_header' ) ) {
	/**
	 * Add a pingback url auto-discovery header for singularly identifiable articles.
	 */
	function inspiry_pingback_header() {
		if ( is_singular() && pings_open() ) {
			printf( '<link rel="pingback" href="%s">' . "\n", esc_url( get_bloginfo( 'pingback_url' ) ) );
		}
	}

	add_action( 'wp_head', 'inspiry_pingback_header' );
}

if ( ! function_exists( 'inspiry_logo_img' ) ) {
	/**
	 * Display logo image
	 * @since   1.0.0
	 *
	 * @param   $logo_url // logo img url
	 * @param   $retina_logo_url // retina logo image url
	 *
	 * @return  void
	 */
	function inspiry_logo_img( $logo_url, $retina_logo_url ) {

		global $is_IE;

		if ( ! empty( $logo_url ) && ! empty( $retina_logo_url ) && ! $is_IE ) {
			echo '<img alt="' . esc_attr( get_bloginfo( 'name' ) ) . '" src="' .  $logo_url . '" srcset="' . esc_url( $logo_url ) . ', ' . esc_url( $retina_logo_url ) . ' 2x">';
		} else {
			echo '<img alt="' . esc_attr( get_bloginfo( 'name' ) ) . '" src="' . esc_url( $retina_logo_url ) . '">';
		}
	}
}

if ( ! function_exists( 'inspiry_site_logo' ) ) {
	/**
	 * Display logo image or site title with description
	 * @since   1.0.0
	 *
	 * @param   $logo_path // logo img url
	 * @param   $retina_logo_path // retina logo image url
	 *
	 * @return  void
	 */
	function inspiry_site_logo() {

		$custom_logo_id   = get_theme_mod( 'custom_logo' );
		$logo_path        = inspiry_filter_protocol( get_theme_mod( 'inspiry_site_logo' ) );
		$retina_logo_path = inspiry_filter_protocol( get_theme_mod( 'inspiry_site_logo_retina' ) );

		if ( $custom_logo_id ) {
			$logo_path = wp_get_attachment_image_url( $custom_logo_id, 'full' );
		}

		if ( ! empty( $retina_logo_path ) ) { ?>
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="site-logo" title="<?php bloginfo( 'name' ); ?>">
				<?php inspiry_logo_img( $logo_path, $retina_logo_path ); ?>
			</a>
			<?php
		} elseif ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) {

			the_custom_logo();

		} else {

			if ( is_front_page() ) {
				?><h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1><?php
			} else {
				?><p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p><?php
			}

			$description = get_bloginfo( 'description' );
			if ( $description ) {
				echo '<small class="tag-line">';
				echo esc_html( $description );
				echo '</small>';
			}
		}
	}
}

if ( ! function_exists( 'tourpress_content_width' ) ) {
	/**
	 * Adds css class to content div when no sidebar is active
	 */
	function tourpress_content_width( $sidebar ) {
		if ( ! is_active_sidebar( $sidebar ) ) {
			echo esc_attr( 'tourpress-content-fullwidth' );
		}
	}
}