</div> <!-- #site-wrapper -->

<div id="site-footer" class="site-footer">

<div class="container">
	<div class="row">
		<?php

		if ( is_active_sidebar( 'footer-1' )
		     || is_active_sidebar( 'footer-2' )
		     || is_active_sidebar( 'footer-3' )
		     || is_active_sidebar( 'footer-4' )
		) {
			?>
			<footer class="clearfix">

				<div class="col-md-3 col-sm-6">
					<?php
						if ( is_active_sidebar( 'footer-1' ) ) {
							dynamic_sidebar( 'footer-1' );
						}
					?>
				</div>
				<div class="col-md-3 col-sm-6">
					<?php
						if ( is_active_sidebar( 'footer-2' ) ) {
							dynamic_sidebar( 'footer-2' );
						}
					?>
				</div>
				<div class="clearfix visible-sm"></div>
				<div class="col-md-3 col-sm-6">
					<?php
						if ( is_active_sidebar( 'footer-3' ) ) {
							dynamic_sidebar( 'footer-3' );
						}
					?>
				</div>
				<div class="col-md-3 col-sm-6">
					<?php
						if ( is_active_sidebar( 'footer-4' ) ) {
							dynamic_sidebar( 'footer-4' );
						}
					?>
				</div>

			</footer>
			<?php
		}

		$footer_socket = get_theme_mod( 'inspiry_footer_socket', 'show' );

		if ( 'show' == $footer_socket ) {

			$copyright = get_theme_mod( 'inspiry_footer_copyright', wp_kses( sprintf( __( "&copy; Copyright %s <a href='%s'>%s</a> - All Right Reserved.", 'inspiry-tourpress' ), date( 'Y' ), get_site_url(), get_bloginfo( 'name' ) ), inspiry_allowed_tags() ) );

			?>
			<div class="bottom-socket clearfix">
				<div class="container">
					<div class="row">
						<div class="col-sm-6">
						<?php
						if ( ! empty( $copyright ) ) {
							echo '<p class="copyright">' . wp_kses( $copyright, inspiry_allowed_tags() ) . '</p>';
						}
						?>
					</div>
					<div class="col-sm-6">
						<?php

						$payments = get_theme_mod( 'inspiry_footer_payments' );

						if ( ! empty( $payments ) ) {

							$payments = explode( ',', $payments );
							echo '<figure class="credit-cards clearfix">';
							foreach ( $payments as $payment ) {
								echo '<img src="' . get_template_directory_uri() . '/img/payment-icons/' . esc_attr( $payment ) . '.svg" alt="' . esc_attr( $payment ) . '">';
							}
							echo '</figure>';
						}
						?>
						</div>
					</div>
				</div>
			</div>
			<?php
		} // End if().
		?>
		<a href="#top" id="scroll-top"><i class="fa fa-chevron-up"></i></a>

	</div>
</div>
</div>

<?php wp_footer(); ?>

</body>
</html>