<?php
if ( ! function_exists( 'generate_dynamic_css' ) ) {
	function generate_dynamic_css( $tourpress_custom_css ) {

		$sidebar = esc_html( get_theme_mod( 'inspiry_tax_archive_sidebar' ) );
		if ( 'disable' === $sidebar ) {
			$dynamic_css_above_1200px_taxonomy = array(
				// Taxonomy & Archive Pages
				array(
					'elements' => '.archive .tours-list-container .tour-post figure',
					'property' => 'width',
					'value'    => '30%',
				),
				array(
					'elements' => '.archive .tours-list-container .tour-post .offer-content',
					'property' => 'width',
					'value'    => '70%',
				),
			);

			/* CSS For min width 1200 */
			$tourpress_custom_css .= "@media (min-width: 1200px) {\n";

			foreach ( $dynamic_css_above_1200px_taxonomy as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$tourpress_custom_css .= $css_unit['elements'] . "{\n";
					$tourpress_custom_css .= $css_unit['property'] . ":" . $css_unit['value'] . ";\n";
					$tourpress_custom_css .= "}\n";
				}
			}

			$tourpress_custom_css .= "}\n";
		}

		if ( 'default' === get_theme_mod( 'inspiry_default_styles', 'default' ) ) {
			return;
		}

		// Core Color
		$inspiry_body_text_color          = get_theme_mod( 'inspiry_body_text_color', '#7E8588' );
		$inspiry_heading_text_color       = get_theme_mod( 'inspiry_heading_text_color', '#2e3031' );
		$inspiry_link_color               = get_theme_mod( 'inspiry_link_color', '#00aeef' );
		$inspiry_link_hover_color         = get_theme_mod( 'inspiry_link_hover_color', '#000000' );
		$inspiry_primary_bg_color         = get_theme_mod( 'inspiry_primary_bg_color', '#00aeef' );
		$inspiry_primary_text_color       = get_theme_mod( 'inspiry_primary_text_color', '#ffffff' );
		$inspiry_primary_bg_hover_color   = get_theme_mod( 'inspiry_primary_bg_hover_color', '#77C720' );
		$inspiry_primary_text_hover_color = get_theme_mod( 'inspiry_primary_text_hover_color', '#ffffff' );
		$inspiry_secondary_bg_color       = get_theme_mod( 'inspiry_secondary_bg_color', '#EA923A' );

		// Header Top Bar Styles
		$inspiry_top_bar_bg_color          = get_theme_mod( 'inspiry_top_bar_bg_color', '#004274' );
		$inspiry_top_bar_text_color        = get_theme_mod( 'inspiry_top_bar_text_color', '#a2bed4' );
		$inspiry_top_bar_text_hover_color  = get_theme_mod( 'inspiry_top_bar_text_hover_color', '#ffffff' );
		$inspiry_top_bar_cart_bg_color     = get_theme_mod( 'inspiry_top_bar_cart_bg_color', '#014b84' );
		$inspiry_top_bar_cart_active_color = get_theme_mod( 'inspiry_top_bar_cart_active_color', '#00aeef' );

		// Header
		$inspiry_header_text_color       = get_theme_mod( 'inspiry_header_text_color', 'inherit' );
		$inspiry_header_text_hover_color = get_theme_mod( 'inspiry_header_text_hover_color', 'inherit' );
		$inspiry_header_bg_color         = get_theme_mod( 'inspiry_header_bg_color', '#ffffff' );

		// Main Menu Styles
		$inspiry_main_menu_color            = get_theme_mod( 'inspiry_main_menu_color', '#606668' );
		$inspiry_main_menu_hover_color      = get_theme_mod( 'inspiry_main_menu_hover_color', '#6bc6f3' );
		$inspiry_sub_menu_bg_color          = get_theme_mod( 'inspiry_sub_menu_bg_color', '#00aeef' );
		$inspiry_sub_menu_text_color        = get_theme_mod( 'inspiry_sub_menu_text_color', '#ffffff' );
		$inspiry_sub_menu_bg_hover_color    = get_theme_mod( 'inspiry_sub_menu_bg_hover_color', '#ffffff' );
		$inspiry_sub_menu_text_hover_color  = get_theme_mod( 'inspiry_sub_menu_text_hover_color', '#606668' );
		$inspiry_sub_menu_item_border_color = get_theme_mod( 'inspiry_sub_menu_item_border_color', '#f1f4f6' );

		// Phone Number
		$inspiry_header_phone_number_color = get_theme_mod( 'inspiry_header_phone_number_color', '#004274' );

		// Mobile Menu
		$inspiry_mobile_menu_bg_color                     = get_theme_mod( 'inspiry_mobile_menu_bg_color', '#004274' );
		$inspiry_mobile_menu_text_color                   = get_theme_mod( 'inspiry_mobile_menu_text_color', '#a2bed4' );
		$inspiry_mobile_menu_expand_button_bg_color       = get_theme_mod( 'inspiry_mobile_menu_expand_button_bg_color', '' );
		$inspiry_mobile_menu_expand_button_bg_hover_color = get_theme_mod( 'inspiry_mobile_menu_expand_button_bg_hover_color', '' );

		// Banner
		$inspiry_banner_bg_color   = get_theme_mod( 'inspiry_banner_bg_color', '#004274' );
		$inspiry_banner_text_color = get_theme_mod( 'inspiry_banner_text_color', '#ffffff' );

		// Footer
		$inspiry_footer_bg_color                = get_theme_mod( 'inspiry_footer_bg_color', '#2D363F' );
		$inspiry_footer_text_color              = get_theme_mod( 'inspiry_footer_text_color', '#B2C3CB' );
		$inspiry_footer_link_color              = get_theme_mod( 'inspiry_footer_link_color', '#9BB8CC' );
		$inspiry_footer_link_hover_color        = get_theme_mod( 'inspiry_footer_link_hover_color', '#ffffff' );
		$inspiry_footer_widget_title_color      = get_theme_mod( 'inspiry_footer_widget_title_color', '#ffffff' );
		$inspiry_footer_bottom_top_border_color = get_theme_mod( 'inspiry_footer_bottom_top_border_color', '#39444F' );

		$dynamic_css = array(

			// Core Styles
			array(
				'elements' => 'body',
				'property' => 'color',
				'value'    => $inspiry_body_text_color,
			),
			array(
				'elements' => 'h1, 
							   h2, 
							   h3, 
							   h4, 
							   h5, 
							   h6, 
							   .h1, 
							   .h2, 
							   .h3, 
							   .h4,
							   .h5
							   .h6,
							   .entry-content strong,
							   .widget.woocommerce .widget-title,
							   .sidebar .widget.woocommerce .widget-title,
							   .sidebar.widget-area .widget .widget-title,
							   .list-style ul:not(.list) li a,
							   .sidebar.widget-area .widget_categories ul:not(.list) li a,
							   .sidebar.widget-area .widget_nav_menu ul:not(.list) li a,
							   .sidebar.widget-area .widget_pages ul:not(.list) li a, 
							   .sidebar.widget-area .widget_archive ul:not(.list) li a, 
							   .sidebar.widget-area .widget_meta ul:not(.list) li a, 
							   .sidebar.widget-area .widget_recent_comments ul:not(.list) li a, 
							   .sidebar.widget-area .widget_recent_entries ul:not(.list) li a, 
							   .widget.woocommerce.widget_layered_nav ul:not(.list) li a, 
							   .widget.woocommerce.widget_product_categories ul:not(.list) li a',
				'property' => 'color',
				'value'    => $inspiry_heading_text_color,
			),
			array(
				'elements' => 'body a',
				'property' => 'color',
				'value'    => $inspiry_link_color,
			),
			array(
				'elements' => 'body a:hover,
				              .list-style ul:not(.list) li a:hover, 
				              .sidebar.widget-area .widget_categories ul:not(.list) li a:hover, 
				              .sidebar.widget-area .widget_nav_menu ul:not(.list) li a:hover, 
				              .sidebar.widget-area .widget_pages ul:not(.list) li a:hover, 
				              .sidebar.widget-area .widget_archive ul:not(.list) li a:hover, 
				              .sidebar.widget-area .widget_meta ul:not(.list) li a:hover, 
				              .sidebar.widget-area .widget_recent_comments ul:not(.list) li a:hover, 
				              .sidebar.widget-area .widget_recent_entries ul:not(.list) li a:hover, 
				              .widget.woocommerce.widget_layered_nav ul:not(.list) li a:hover, 
				              .widget.woocommerce.widget_product_categories ul:not(.list) li a:hover',
				'property' => 'color',
				'value'    => $inspiry_link_hover_color,
			),

			// Primary Color
			array(
				'elements' => '.read-more,
							   #search-form-wrapper .search-form form input[type=submit],
							   .contact-section .contact-form input[type="submit"],
							   .widget_search input[type=submit],
							   .woocommerce .wrapper-buttons-add-cart .add_to_cart_button, 
							   .woocommerce .wrapper-buttons-add-cart .added_to_cart, 
							   .woocommerce .wrapper-buttons-add-cart .button,
							   .woocommerce span.onsale,
							   .widget.woocommerce.widget_price_filter button,
							   .widget.woocommerce.widget_price_filter .ui-slider .ui-slider-range,
							    .widget.woocommerce.widget_price_filter .ui-slider .ui-slider-handle,
							    #respond #commentform .submit,
							    .pagination .nav-links .current,
							    .inspiry_tours_search_widget #tours-search input[type="submit"]:hover,
							    .inspiry_booking_widget .tour-booking input[type="submit"]:hover,
							    .btn-inspiry-download,
							    .single-tour .tour-tabs li.active, 
							    .single-tour .tour-tabs li:hover,
							    .single-tour .tour-meta-bar .tour-tags .tag-price,
							    .woocommerce-cart table.cart input[type="submit"],
							    .woocommerce-cart table.cart a.button, 
							    .woocommerce-cart table.cart button.button,
							    .woocommerce-cart table.cart input.button,
							    .woocommerce-cart a.button, 
							    .woocommerce-cart a.button.alt,
							    .mini-cart-wrap .buttons a,
							    .sidebar.widget-area .tagcloud a:hover,
							    .widget.woocommerce .widget_shopping_cart_content .button,
							    .woocommerce .woocommerce-checkout-payment .place-order #place_order,
							    .select2-container--default .select2-selection--single .select2-selection__arrow,
							    .woocommerce form.login input[type="submit"], .woocommerce form.login button, .woocommerce form.lost_reset_password input[type="submit"], .woocommerce form.lost_reset_password button,
							    .woocommerce .woocommerce-message a, .woocommerce .woocommerce-message button, .woocommerce .woocommerce-info a, .woocommerce .woocommerce-info button, .woocommerce .woocommerce-error a, .woocommerce .woocommerce-error button, .woocommerce .woocommerce-form-coupon a, .woocommerce .woocommerce-form-coupon button',
				'property' => 'background-color',
				'value'    => $inspiry_primary_bg_color,
			),
			array(
				'elements' => '.read-more:visited, 
							   .read-more:focus, 
							   .read-more:active, 
							   .read-more.nice-select.open,
							   .tours-listing .tour-post .offer-content .tour-price,
							   .widget.inspiry_top_rated_tours_widget .content .offer-price,
							   #search-form-wrapper .search-form form input[type=submit],
							   .contact-section .contact-form input[type="submit"],
							   .widget_search input[type=submit],
							   .woocommerce .wrapper-buttons-add-cart .add_to_cart_button, 
							   .woocommerce .wrapper-buttons-add-cart .added_to_cart, 
							   .woocommerce .wrapper-buttons-add-cart .button,
							   .woocommerce span.onsale,
							   .widget.woocommerce.widget_price_filter button,
							   #respond #commentform .submit,
							   .pagination .nav-links .current,
							   .inspiry_tours_search_widget #tours-search input[type="submit"]:hover,
							   .inspiry_booking_widget .tour-booking input[type="submit"]:hover,
							   .btn-inspiry-download,
							   .single-tour .tour-tabs li.active,
							   .single-tour .tour-tabs li:hover,
							   .single-tour .tour-meta-bar .tour-tags .tag-price,
							   .woocommerce-cart table.cart input[type="submit"], 
							   .woocommerce-cart table.cart a.button, 
							   .woocommerce-cart table.cart button.button, 
							   .woocommerce-cart table.cart input.button,
							   .woocommerce-cart a.button, 
							   .woocommerce-cart a.button.alt,
							   .mini-cart-wrap .buttons a,
							   .sidebar.widget-area .tagcloud a:hover,
							   .widget.woocommerce .widget_shopping_cart_content .button,
							   .woocommerce form.login input[type="submit"], .woocommerce form.login button, .woocommerce form.lost_reset_password input[type="submit"], .woocommerce form.lost_reset_password button,
							   .woocommerce .woocommerce-checkout-payment .place-order #place_order,
							   .woocommerce .woocommerce-message a, .woocommerce .woocommerce-message button, .woocommerce .woocommerce-info a, .woocommerce .woocommerce-info button, .woocommerce .woocommerce-error a, .woocommerce .woocommerce-error button, .woocommerce .woocommerce-form-coupon a, .woocommerce .woocommerce-form-coupon button',
				'property' => 'color',
				'value'    => $inspiry_primary_text_color,
			),
			array(
				'elements' => '.read-more:hover,
							   #search-form-wrapper .search-form form input[type=submit]:hover,
							   .contact-section .contact-form input[type="submit"]:hover,
							   .widget_search input[type=submit]:hover,
							   .woocommerce .wrapper-buttons-add-cart .add_to_cart_button:hover, 
							   .woocommerce .wrapper-buttons-add-cart .added_to_cart:hover, 
							   .woocommerce .wrapper-buttons-add-cart .button:hover,
							   .widget.woocommerce.widget_price_filter button:hover,
							   #respond #commentform .submit:hover,
							   .pagination .nav-links a:hover,
							   .pagination .nav-links > span,
							   .inspiry_tours_search_widget #tours-search input[type="submit"],
							   .inspiry_booking_widget .tour-booking input[type="submit"],
							   .btn-inspiry-download:hover,
							   .inspiry_booking_widget header span,
							   .tours-listing .tour-post .offer-content .discount-label,
							   .explore-tours .content .read-more:hover,
							   .woocommerce-cart table.cart input[type="submit"]:hover, 
							   .woocommerce-cart table.cart a.button:hover,
							   .woocommerce-cart table.cart button.button:hover,
							   .woocommerce-cart table.cart input.button:hover,
							   .woocommerce-cart a.button:hover,
							   .woocommerce-cart a.button.alt:hover,
							   .mini-cart-wrap .buttons a:hover,
							   .widget.woocommerce .widget_shopping_cart_content .button:hover,
							   .woocommerce form.login input[type="submit"]:hover, .woocommerce form.login button:hover, .woocommerce form.lost_reset_password input[type="submit"]:hover, .woocommerce form.lost_reset_password button:hover,
							   .woocommerce .woocommerce-checkout-payment .place-order #place_order:hover,
							   .woocommerce .woocommerce-message a:hover, .woocommerce .woocommerce-message button:hover, .woocommerce .woocommerce-info a:hover, .woocommerce .woocommerce-info button:hover, .woocommerce .woocommerce-error a:hover, .woocommerce .woocommerce-error button:hover, .woocommerce .woocommerce-form-coupon a:hover, .woocommerce .woocommerce-form-coupon button:hover',
				'property' => 'background-color',
				'value'    => $inspiry_primary_bg_hover_color,
			),
			array(
				'elements' => '.read-more:hover,
							   #search-form-wrapper .search-form form input[type=submit]:hover,
							   .contact-section .contact-form input[type="submit"]:hover,
							   .widget_search input[type=submit]:hover,
							   .woocommerce .wrapper-buttons-add-cart .add_to_cart_button:hover, 
							   .woocommerce .wrapper-buttons-add-cart .added_to_cart:hover, 
							   .woocommerce .wrapper-buttons-add-cart .button:hover,
							   .widget.woocommerce.widget_price_filter button:hover,
							   #respond #commentform .submit:hover,
							   .pagination .nav-links a:hover,
							   .pagination .nav-links > span,
							   .inspiry_tours_search_widget #tours-search input[type="submit"],
							   .inspiry_booking_widget .tour-booking input[type="submit"],
							   .btn-inspiry-download:hover,
							   .inspiry_booking_widget header span,
							   .tours-listing .tour-post .offer-content .discount-label,
							   .explore-tours .content .read-more:hover,
							   .woocommerce-cart table.cart input[type="submit"]:hover, 
							   .woocommerce-cart table.cart a.button:hover, 
							   .woocommerce-cart table.cart button.button:hover, 
							   .woocommerce-cart table.cart input.button:hover,
							   .woocommerce-cart a.button:hover, 
							   .woocommerce-cart a.button.alt:hover,
							   .widget.woocommerce .widget_shopping_cart_content .button:hover,
							   .mini-cart-wrap .buttons a:hover,
							   .inspiry_tours_widget .tour-destination .offer-price,
							   .woocommerce form.login input[type="submit"]:hover, .woocommerce form.login button:hover, .woocommerce form.lost_reset_password input[type="submit"]:hover, .woocommerce form.lost_reset_password button:hover,
							   .woocommerce .woocommerce-checkout-payment .place-order #place_order:hover,
							   .woocommerce .woocommerce-message a:hover, .woocommerce .woocommerce-message button:hover, .woocommerce .woocommerce-info a:hover, .woocommerce .woocommerce-info button:hover, .woocommerce .woocommerce-error a:hover, .woocommerce .woocommerce-error button:hover, .woocommerce .woocommerce-form-coupon a:hover, .woocommerce .woocommerce-form-coupon button:hover',
				'property' => 'color',
				'value'    => $inspiry_primary_text_hover_color,
			),
			array(
				'elements' => '#scroll-top:hover,
							   .woocommerce .checkout_coupon input,
							   .entry-content blockquote,
							   .widget.woocommerce.widget_price_filter .ui-slider .ui-slider-handle
							   .woocommerce .woocommerce-message, .woocommerce .woocommerce-info, .woocommerce .woocommerce-error, .woocommerce .woocommerce-form-coupon',
				'property' => 'border-color',
				'value'    => $inspiry_primary_bg_color,
			),
			array(
				'elements' => '.woocommerce .woocommerce-checkout .woocommerce-validated input.input-text',
				'property' => 'border-color',
				'value'    => $inspiry_primary_bg_color . ' !important',
			),
			array(
				'elements' => '.single-tour .tour-meta-bar li svg *',
				'property' => 'stroke',
				'value'    => $inspiry_primary_bg_color,
			),
			array(
				'elements' => '.select2-container--default .select2-results__option--highlighted[aria-selected], .select2-container--default .select2-results__option--highlighted[data-selected]',
				'property' => 'background-color',
				'value'    => $inspiry_primary_bg_color . ' !important',
			),
			array(
				'elements' => '#scroll-top:hover',
				'property' => 'color',
				'value'    => $inspiry_primary_bg_color,
			),
			array(
				'elements' => '.single-tour .tour-include i',
				'property' => 'color',
				'value'    => $inspiry_primary_bg_hover_color,
			),
			array(
				'elements' => '.inspiry_tours_widget .tour-destination .offer-price,
				               .special-offers .tour-offer figure .offer-price',
				'property' => 'background-color',
				'value'    => inspiry_hex_to_rgba( $inspiry_primary_bg_hover_color, .8 ),
			),


			// Secondary Color
			array(
				'elements' => '.home-slider .slide .detail .price .arrow,
							   .explore-tours .content .read-more',
				'property' => 'background-color',
				'value'    => $inspiry_secondary_bg_color,
			),
			array(
				'elements' => '.rating i.rated',
				'property' => 'color',
				'value'    => $inspiry_secondary_bg_color,
			),
			array(
				'elements' => '#search-form-wrapper .search-form form .form-field svg',
				'property' => 'border-color',
				'value'    => $inspiry_secondary_bg_color,
			),
			array(
				'elements' => '#search-form-wrapper .search-form form .form-field svg',
				'property' => 'fill',
				'value'    => $inspiry_secondary_bg_color,
			),

			// Header Styles
			array(
				'elements' => '.top-bar',
				'property' => 'background-color',
				'value'    => $inspiry_top_bar_bg_color,
			),
			array(
				'elements' => '.top-bar, 
							   .top-bar a,
							   .top-bar .smart-social .shopping-cart .active-cart,
							   .mini-cart-wrap .cart_list .mini_cart_item .right-content .quantity,
							   .mini-cart-wrap .total',
				'property' => 'color',
				'value'    => $inspiry_top_bar_text_color,
			),
			array(
				'elements' => '.top-bar a:hover',
				'property' => 'color',
				'value'    => $inspiry_top_bar_text_hover_color,
			),
			array(
				'elements' => '.top-bar .smart-social .shopping-cart .shopping-cart-icon',
				'property' => 'fill',
				'value'    => $inspiry_top_bar_text_color,
			),
			array(
				'elements' => '.top-bar .smart-social .shopping-cart:hover .shopping-cart-icon',
				'property' => 'fill',
				'value'    => $inspiry_top_bar_text_hover_color,
			),
			array(
				'elements' => '.mini-cart-wrap',
				'property' => 'background-color',
				'value'    => $inspiry_top_bar_cart_bg_color,
			),
			array(
				'elements' => '.top-bar .smart-social .shopping-cart .active-cart',
				'property' => 'background-color',
				'value'    => $inspiry_top_bar_cart_active_color,
			),

			// Header
			array(
				'elements' => '.header header, .header header a',
				'property' => 'color',
				'value'    => $inspiry_header_text_color,
			),
			array(
				'elements' => '.header header a:hover',
				'property' => 'color',
				'value'    => $inspiry_header_text_hover_color,
			),
			array(
				'elements' => '.header header',
				'property' => 'background-color',
				'value'    => $inspiry_header_bg_color,
			),

			// Main Menu Styles
			array(
				'elements' => '.header header .main-menu > li a, 
							   .header header .main-menu > ul li a',
				'property' => 'color',
				'value'    => $inspiry_main_menu_color,
			),
			array(
				'elements' => '.header header .main-menu > li a:hover,
				               .header header .main-menu > ul li a:hover,
				   			   .header header .main-menu > li.current_page_item > a,
				               .header header .main-menu > li.current-menu-ancestor > a,
				               .header header .main-menu > ul li.current_page_item > a, 
				               .header header .main-menu > ul li.current-menu-ancestor > a',
				'property' => 'color',
				'value'    => $inspiry_main_menu_hover_color,
			),
			array(
				'elements' => '.header header .main-menu > li.current_page_item:before,
				               .header header .main-menu > li.current-menu-ancestor:before,
				               .header header .main-menu > ul li.current_page_item:before, 
				               .header header .main-menu > ul li.current-menu-ancestor:before',
				'property' => 'border-bottom-color',
				'value'    => $inspiry_main_menu_hover_color,
			),
			array(
				'elements' => '.header header .main-menu > li.current_page_item,
				               .header header .main-menu > li.current-menu-ancestor,
				               .header header .main-menu > ul li.current_page_item, 
				               .header header .main-menu > ul li.current-menu-ancestor',
				'property' => 'border-color',
				'value'    => $inspiry_main_menu_hover_color,
			),
			array(
				'elements' => '.header header .main-menu > li .sub-menu, 
							   .header header .main-menu > ul li .sub-menu',
				'property' => 'background-color',
				'value'    => $inspiry_sub_menu_bg_color,
			),
			array(
				'elements' => '.header header .main-menu > li .sub-menu li a, 
							   .header header .main-menu > ul li .sub-menu li a',
				'property' => 'color',
				'value'    => $inspiry_sub_menu_text_color,
			),
			array(
				'elements' => '.header header .main-menu > li .sub-menu li a:hover, 
							   .header header .main-menu > ul li .sub-menu li a:hover',
				'property' => 'background-color',
				'value'    => $inspiry_sub_menu_bg_hover_color,
			),
			array(
				'elements' => '.header header .main-menu > li .sub-menu li a:hover, 
							   .header header .main-menu > ul li .sub-menu li a:hover',
				'property' => 'color',
				'value'    => $inspiry_sub_menu_text_hover_color,
			),
			array(
				'elements' => '.header header .main-menu > li .sub-menu li, 
							   .header header .main-menu > ul li .sub-menu li',
				'property' => 'border-bottom-color',
				'value'    => $inspiry_sub_menu_item_border_color,
			),

			// Phone Number
			array(
				'elements' => '.header header .header-phone',
				'property' => 'color',
				'value'    => $inspiry_header_phone_number_color,
			),
			array(
				'elements' => '.header header .header-phone svg',
				'property' => 'fill',
				'value'    => $inspiry_header_phone_number_color,
			),

			// Mobile Menu
			array(
				'elements' => '.mean-container .mean-nav,
							   .mean-container .mean-bar
							   ',
				'property' => 'background',
				'value'    => $inspiry_mobile_menu_bg_color,
			),
			array(
				'elements' => '.mean-container .mean-nav ul li a',
				'property' => 'color',
				'value'    => $inspiry_mobile_menu_text_color,
			),
			array(
				'elements' => '.mean-container a.meanmenu-reveal span',
				'property' => 'background-color',
				'value'    => $inspiry_mobile_menu_text_color,
			),
			array(
				'elements' => '.mean-container .mean-nav ul li a.mean-expand',
				'property' => 'background-color',
				'value'    => $inspiry_mobile_menu_expand_button_bg_color . ' !important',
			),
			array(
				'elements' => '.mean-container .mean-nav ul li a.mean-expand:hover, .mean-container .mean-nav ul li a.mean-expand.mean-clicked',
				'property' => 'background-color',
				'value'    => $inspiry_mobile_menu_expand_button_bg_hover_color . ' !important',
			),

			// Banner
			array(
				'elements' => '#site-banner',
				'property' => 'background-color',
				'value'    => $inspiry_banner_bg_color,
			),
			array(
				'elements' => '#site-banner',
				'property' => 'color',
				'value'    => $inspiry_banner_text_color,
			),

			// Footer
			array(
				'elements' => '.site-footer',
				'property' => 'background-color',
				'value'    => $inspiry_footer_bg_color,
			),
			array(
				'elements' => '.site-footer',
				'property' => 'color',
				'value'    => $inspiry_footer_text_color,
			),
			array(
				'elements' => '.site-footer footer a,
							   .bottom-socket .copyright a,
							   .list-style-footer ul:not(.list) li a, 
							   .site-footer .widget_pages ul:not(.list) li a, 
							   .site-footer .widget_nav_menu ul:not(.list) li a, 
							   .site-footer .widget_archive ul:not(.list) li a, 
							   .site-footer .widget_meta ul:not(.list) li a, 
							   .site-footer .widget_recent_comments ul:not(.list) li a, 
							   .site-footer .widget_recent_entries ul:not(.list) li a, 
							   .site-footer .widget.woocommerce.widget_layered_nav ul:not(.list) li a, 
							   .site-footer .widget.woocommerce.widget_product_categories ul:not(.list) li a',
				'property' => 'color',
				'value'    => $inspiry_footer_link_color,
			),
			array(
				'elements' => '.site-footer footer a:hover,
							   .bottom-socket .copyright a:hover,
							   .list-style-footer ul:not(.list) li a:hover, 
							   .site-footer .widget_pages ul:not(.list) li a:hover, 
							   .site-footer .widget_nav_menu ul:not(.list) li a:hover, 
							   .site-footer .widget_archive ul:not(.list) li a:hover, 
							   .site-footer .widget_meta ul:not(.list) li a:hover, 
							   .site-footer .widget_recent_comments ul:not(.list) li a:hover, 
							   .site-footer .widget_recent_entries ul:not(.list) li a:hover, 
							   .site-footer .widget.woocommerce.widget_layered_nav ul:not(.list) li a:hover, 
							   .site-footer .widget.woocommerce.widget_product_categories ul:not(.list) li a:hover',
				'property' => 'color',
				'value'    => $inspiry_footer_link_hover_color,
			),
			array(
				'elements' => '.widget_tag_cloud .tagcloud a',
				'property' => 'background-color',
				'value'    => $inspiry_footer_link_color,
			),
			array(
				'elements' => '.widget_tag_cloud .tagcloud a:hover',
				'property' => 'background-color',
				'value'    => $inspiry_footer_link_hover_color,
			),
			array(
				'elements' => '.widget .widget-title',
				'property' => 'color',
				'value'    => $inspiry_footer_widget_title_color,
			),
			array(
				'elements' => '.bottom-socket',
				'property' => 'border-top-color',
				'value'    => $inspiry_footer_bottom_top_border_color,
			),
		);

		$prop_count = count( $dynamic_css );

		$dynamic_css_above_1200px = array(
			array(
				'elements' => '.top-bar .smart-social .shopping-cart',
				'property' => 'background-color',
				'value'    => $inspiry_top_bar_cart_bg_color,
			),
		);

		if ( $prop_count > 0 ) {

			foreach ( $dynamic_css as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$tourpress_custom_css .= $css_unit['elements'] . "{\n";
					$tourpress_custom_css .= $css_unit['property'] . ":" . $css_unit['value'] . ";\n";
					$tourpress_custom_css .= "}\n";
				}
			}

			/* CSS For min width 1200 */
			$tourpress_custom_css .= "@media (min-width: 1200px) {\n";

			foreach ( $dynamic_css_above_1200px as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$tourpress_custom_css .= $css_unit['elements'] . "{\n";
					$tourpress_custom_css .= $css_unit['property'] . ":" . $css_unit['value'] . ";\n";
					$tourpress_custom_css .= "}\n";
				}
			}

			$tourpress_custom_css .= "}\n";
		}

		return $tourpress_custom_css;
	}
}

if ( ! is_admin() ) {
	add_filter( 'tourpress_custom_css', 'generate_dynamic_css' );
}