<?php
	/**
	 * The template for displaying Comments.
	 *
	 * The area of the page that contains comments and the comment form.
	 */

	/*
	 * If the current post is protected by a password and the visitor has not yet
	 * entered the password we will return early without loading the comments.
	 */
	if ( post_password_required() ) {
		return;
	}
?>

<div id="comments">
	<?php
		if ( have_comments() ) :

			if ( ! is_singular( 'tour' ) ) {
				?>
				<h2 class="comments-title">
					<?php esc_html_e( 'Recent Comments', 'inspiry-tourpress' ); ?>
				</h2>
				<?php
			}
			?>
			<ol class="comment-list">
				<?php
					wp_list_comments( array(
						'style'       => 'ol',
						'callback'    => 'inspiry_comment_list',
						'avatar_size' => 114,
					) );
				?>
			</ol><!-- .comment-list -->
			<?php
			// Are there comments to navigate through?
			if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
				?>
				<nav class="navigation comment-navigation">
					<h1 class="screen-reader-text section-heading"><?php esc_html_e( 'Comment navigation', 'inspiry-tourpress' ); ?></h1>
					<div
						class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'inspiry-tourpress' ) ); ?></div>
					<div
						class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'inspiry-tourpress' ) ); ?></div>
				</nav><!-- .comment-navigation -->
			<?php endif; // Check for comment navigation
			?>

			<?php if ( ! comments_open() && get_comments_number() ) : ?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'inspiry-tourpress' ); ?></p>
			<?php
		endif;

		endif; // have_comments() ?>

	<?php
		$title_reply = ( is_singular( 'tour' ) ) ? esc_html__( 'Leave a Review', 'inspiry-tourpress' ) : esc_html__( 'Leave a Reply', 'inspiry-tourpress' );
		comment_form( array(
			'title_reply' => $title_reply,
		) );
	?>
</div><!-- #comments -->