<?php
/**
Plugin Name: TourPress Pack
Description: TourPress Pack provides Testimonial post type, contact form and related functionality.
Version: 1.0.4
Author: InspiryThemes
Author URI: https://inspirythemes.com
Text Domain: tourpress-pack
Domain Path: /languages
*/

/**
 * Loading plugin text domain
 * @since    1.0.0
 */
function inspiry_load_plugin_textdomain() {
	load_plugin_textdomain( 'tourpress-pack', false, basename( dirname( __FILE__ ) ) . '/languages' );
}
add_action( 'plugins_loaded', 'inspiry_load_plugin_textdomain' );

/**
 * The core plugin class that is used to define admin functionality.
 * @since    1.0.0
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-tourpress-pack.php';


if ( ! function_exists( 'inspiry_debugging_info' ) ) {
	/**
	 * Display commented debugging info in the site head
	 */
	function inspiry_debugging_info() {

		if ( is_feed() ) {
			return;
		}

		$theme = wp_get_theme();
		$child = "";

		if ( is_child_theme() ) {

			$child = "- - - - - - - - - - -\n";
			$child .= "ChildTheme: " . $theme->get( 'Name' ) . "\n";
			$child .= "ChildTheme Version: " . $theme->get( 'Version' ) . "\n";
			$child .= "ChildTheme Installed: " . $theme->get( 'Template' ) . "\n\n";

			$theme = wp_get_theme( $theme->get( 'Template' ) );
		}

		$info = "\n\n<!--\n";
		$info .= "Debugging Info for the theme support: \n\n";
		$info .= "Theme: " . $theme->get( 'Name' ) . "\n";
		$info .= "Version: " . $theme->get( 'Version' ) . "\n";
		$info .= "Installed: " . $theme->get_template() . "\n";

		$info .= $child;

		//memory setting, peak usage and number of active plugins
		$info .= "ML:" . trim( @ini_get( 'memory_limit' ), 'M' ) . " PU:" . ( ceil( memory_get_peak_usage() / 1000 / 1000 ) ) . " AP:" . count( get_option( 'active_plugins' ) ) . "\n";
		$info .= "WP:" . get_bloginfo( 'version' ) . "\n";

		$info .= "-->\n\n";
		echo apply_filters( 'inspiry_debugging_info', $info );
	}
}
add_action( 'wp_head', 'inspiry_debugging_info', 1000 );
add_action( 'admin_print_scripts', 'inspiry_debugging_info', 1000 );

if ( ! function_exists( 'inspiry_search_form' ) ) {
	/**
	 * Modify the default search form
	 * @since   1.0.0
	 * @return  string
	 */
	function inspiry_search_form() {

		$form = '<form role="search" method="get" class="search-form clearfix" action="' . esc_url( home_url( '/' ) ) . '">
			<span class="screen-reader-text">' . esc_html_x( 'Search for:', 'label', 'inspiry-tourpress' ) . '</span>
			<input type="search" class="search-field" placeholder="' . esc_attr_x( 'Search', 'placeholder', 'inspiry-tourpress' ) . '" value="' . esc_attr( get_search_query() ) . '" name="s" />
			<input type="submit" class="search-submit" value="' . esc_attr_x( 'Go', 'submit button', 'inspiry-tourpress' ) . '" />
			</form>';

		return $form;
	}
}
add_filter( 'get_search_form', 'inspiry_search_form' );