<?php
/**
 * User Functions
 */
if ( ! function_exists( 'inspiry_user_social_links' ) ) {
	/**
	 * Add custom fields to the user profile.
	 *
	 * @param object $user
	 *
	 * @return void
	 */
	function inspiry_user_social_links( $user ) {
		?>
        <h3><?php esc_html_e( 'Social Profile Links', 'tourpress-pack' ); ?></h3>

        <table class="form-table">
            <tr>
                <th><label for="facebook_profile"><?php esc_html_e( 'Facebook Profile', 'tourpress-pack' ); ?></label></th>
                <td>
                    <input type="text" name="facebook_profile" value="<?php echo esc_attr( get_the_author_meta( 'facebook_profile', $user->ID ) ); ?>" class="regular-text"/>
                </td>
            </tr>

            <tr>
                <th><label for="twitter_profile"><?php esc_html_e( 'Twitter Profile', 'tourpress-pack' ); ?></label></th>
                <td>
                    <input type="text" name="twitter_profile" value="<?php echo esc_attr( get_the_author_meta( 'twitter_profile', $user->ID ) ); ?>" class="regular-text"/>
                </td>
            </tr>
            <tr>
                <th><label for="youtube_profile"><?php esc_html_e( 'YouTube Profile', 'tourpress-pack' ); ?></label></th>
                <td>
                    <input type="text" name="youtube_profile" value="<?php echo esc_attr( get_the_author_meta( 'youtube_profile', $user->ID ) ); ?>" class="regular-text"/>
                </td>
            </tr>
            <tr>
                <th><label for="instagram_profile"><?php esc_html_e( 'Instagram Profile', 'tourpress-pack' ); ?></label></th>
                <td>
                    <input type="text" name="instagram_profile" value="<?php echo esc_attr( get_the_author_meta( 'instagram_profile', $user->ID ) ); ?>" class="regular-text"/>
                </td>
            </tr>
        </table>
		<?php
	}

	add_action( 'show_user_profile', 'inspiry_user_social_links' );
	add_action( 'edit_user_profile', 'inspiry_user_social_links' );
}

if ( ! function_exists( 'inspiry_save_user_social_links' ) ) {
	/**
	 * Save custom user fields data.
	 *
	 * @param int $user_id
	 *
	 * @return void
	 */
	function inspiry_save_user_social_links( $user_id ) {
		update_user_meta( $user_id, 'facebook_profile', sanitize_text_field( $_POST['facebook_profile'] ) );
		update_user_meta( $user_id, 'twitter_profile', sanitize_text_field( $_POST['twitter_profile'] ) );
		update_user_meta( $user_id, 'youtube_profile', sanitize_text_field( $_POST['youtube_profile'] ) );
		update_user_meta( $user_id, 'instagram_profile', sanitize_text_field( $_POST['instagram_profile'] ) );
	}

	add_action( 'personal_options_update', 'inspiry_save_user_social_links' );
	add_action( 'edit_user_profile_update', 'inspiry_save_user_social_links' );
}

if ( ! function_exists( 'inspiry_wc_social_share_icons' ) ) {
	/**
	 * Social share icons for WooCommerce product
	 */
	function inspiry_wc_social_share_icons() {

		global $post;
		$permalink  = get_permalink( $post->ID );
		$post_title = rawurlencode( get_the_title( $post->ID ) );

		?>
		<div class="share-social-icons">

			<a class="facebook" href="http://www.facebook.com/sharer.php?u=<?php echo esc_url( $permalink ); ?>" target="_blank" title="<?php esc_html_e( 'Share on Facebook', 'tourpress-pack' ); ?>">
				<i class="fa fa-facebook"></i> </a>

			<a class="twitter" href="https://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>" target="_blank" title="<?php esc_html_e( 'Share on Twitter', 'tourpress-pack' ); ?>">
				<i class="fa fa-twitter"></i> </a>
			<?php
				$featured_image_src = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'large' );
				$featured_image     = $featured_image_src['0'];
			?>
			<a class="pinterest" href="//pinterest.com/pin/create/button/?url=<?php echo esc_url( $permalink ); ?>&amp;media=<?php echo esc_url( $featured_image ); ?>&amp;description=<?php echo esc_html( $post_title ); ?>" target="_blank" title="<?php esc_html_e( 'Pin on Pinterest', 'tourpress-pack' ); ?>">
				<i class="fa fa-pinterest"></i> </a>
		</div>
		<?php
	}

	add_action( 'woocommerce_share', 'inspiry_wc_social_share_icons' );
}

if( ! function_exists( 'inspiry_contact_social_profiles_icons' ) ) {
	/**
	 * Social profiles icons for contact page
	 */
	function inspiry_contact_social_profiles_icons(){

		$meta_data = get_post_custom();

		if ( 'show' === $meta_data['Inspiry_Tours_social_display'][0] ) {
			?>
			<section class="contact-section inspiry-box-shadow social-pro-wrap clearfix white-bg">
				<div class="social-profile">
					<?php
						if ( ! empty( $meta_data['Inspiry_Tours_social_title'][0] ) ) {
							echo '<h3>' . esc_html( $meta_data['Inspiry_Tours_social_title'][0] ) . '</h3>';
						}

						if ( inspiry_contact_social_profiles( $meta_data ) ) {
							?>
							<ul class="social-buttons clearfix">
								<?php

									// facebook
									if ( ! empty( $meta_data['Inspiry_Tours_facebook_profile'][0] ) ) {
										?>
										<li class="facebook">
											<a href="<?php echo esc_url( $meta_data['Inspiry_Tours_facebook_profile'][0] ); ?>" target="_blank">
												<i class="fa fa-facebook" aria-hidden="true"></i>
											</a>
										</li>
										<?php
									}

									// twitter
									if ( ! empty( $meta_data['Inspiry_Tours_twitter_profile'][0] ) ) {
										?>
										<li class="twitter">
											<a href="<?php echo esc_url( $meta_data['Inspiry_Tours_twitter_profile'][0] ); ?>" target="_blank">
												<i class="fa fa-twitter" aria-hidden="true"></i>
											</a>
										</li>
										<?php
									}

									// instagram
									if ( ! empty( $meta_data['Inspiry_Tours_instagram_profile'][0] ) ) {
										?>
										<li class="instagram">
											<a href="<?php echo esc_url( $meta_data['Inspiry_Tours_instagram_profile'][0] ); ?>" target="_blank">
												<i class="fa fa-instagram" aria-hidden="true"></i>
											</a>
										</li>
										<?php
									}

									// pinterest
									if ( ! empty( $meta_data['Inspiry_Tours_pinterest_profile'][0] ) ) {
										?>
										<li class="pinterest">
											<a href="<?php echo esc_url( $meta_data['Inspiry_Tours_pinterest_profile'][0] ); ?>" target="_blank">
												<i class="fa fa-pinterest-p" aria-hidden="true"></i>
											</a>
										</li>
										<?php
									}
								?>
							</ul>
							<?php
						} else {
							echo '<p>' . esc_html__( 'No Social Profile link is set.', 'tourpress-pack' ) . '</p>';
						}
					?>
				</div>
			</section>
			<?php
		}
	}
	add_action( 'inspiry_contact_page_social_profiles', 'inspiry_contact_social_profiles_icons' );
}

if ( ! function_exists( 'inspiry_topbar_social_profiles_icons' ) ) {
	function inspiry_topbar_social_profiles_icons( $header_social ) {
		echo ( ! empty( $header_social['twitter'] ) ) ? '<li><a target="_blank" href="' . esc_url( $header_social['twitter'] ) . '"><i class="fa fa-twitter"></i></a></li>' : '';
		echo ( ! empty( $header_social['facebook'] ) ) ? '<li><a target="_blank" href="' . esc_url( $header_social['facebook'] ) . '"><i class="fa fa-facebook-official"></i></a></li>' : '';
		echo ( ! empty( $header_social['youtube'] ) ) ? '<li><a target="_blank" href="' . esc_url( $header_social['youtube'] ) . '"><i class="fa fa-youtube-play"></i></a></li>' : '';
		echo ( ! empty( $header_social['instagram'] ) ) ? '<li><a target="_blank" href="' . esc_url( $header_social['instagram'] ) . '"><i class="fa fa-instagram"></i></a></li>' : '';
	}
	add_action( 'inspiry_topbar_social_profiles', 'inspiry_topbar_social_profiles_icons' );
}

if ( ! function_exists( 'inspiry_author_social_profiles_icons' ) ) {
	function inspiry_author_social_profiles_icons( $author_meta ) {

		if ( ! empty( $author_meta['twitter_profile'][0] ) ) :
			echo '<li><a class="twitter" target="_blank" href="' . esc_url( $author_meta['twitter_profile'][0] ) . '"><i class="fa fa-twitter"></i></a></li>';
		endif;

		if ( ! empty( $author_meta['facebook_profile'][0] ) ) :
			echo '<li><a class="facebook" target="_blank" href="' . esc_url( $author_meta['facebook_profile'][0] ) . '"><i class="fa fa-facebook-official"></i></a></li>';
		endif;

		if ( ! empty( $author_meta['youtube_profile'][0] ) ) :
			echo '<li><a class="youtube" target="_blank" href="' . esc_url( $author_meta['youtube_profile'][0] ) . '"><i class="fa fa-youtube"></i></a></li>';
		endif;

		if ( ! empty( $author_meta['instagram_profile'][0] ) ) :
			echo '<li><a class="instagram" target="_blank" href="' . esc_url( $author_meta['instagram_profile'][0] ) . '"><i class="fa fa-instagram"></i></a></li>';
		endif;
	}
	add_action( 'inspiry_author_social_profiles', 'inspiry_author_social_profiles_icons' );
}