<?php
if ( ! function_exists( 'inspiry_tour_search_form_shortcode' ) ) {
	/**
	 * Tour search form shortcode
	 */
	function inspiry_tour_search_form_shortcode() {

		$search_page_id = get_theme_mod( 'inspiry_search_page', 0 );
		if ( 0 != $search_page_id && function_exists( 'inspiry_taxonomy_options' ) ) {
			$search_page_url = get_the_permalink( $search_page_id );
			?>
            <form id="tours-search" action="<?php echo esc_url( $search_page_url ); ?>" class="clearfix">
                <div class="form-field tour-destination">
					<?php include get_theme_file_path( '/img/svg/pin.svg' ); ?>
                    <select name="destination" id="tour-destination">
                        <option value=""><?php esc_html_e( 'Destination (Any)', 'tourpress-pack' ); ?></option>
						<?php inspiry_taxonomy_options( 'tour-destination', 'destination' ); ?>
                    </select>
                </div>
                <div class="form-field tour-type">
					<?php include get_theme_file_path( '/img/svg/type-list.svg' ); ?>
                    <select name="type" id="tour-type">
                        <option value=""><?php esc_html_e( 'Tour Type (Any)', 'tourpress-pack' ); ?></option>
						<?php inspiry_taxonomy_options( 'tour-type', 'type' ); ?>
                    </select>
                </div>
                <div class="form-field tour-month">
					<?php include get_theme_file_path( '/img/svg/calender.svg' ); ?>
                    <select name="month" id="tour-month">
                        <option value=""><?php esc_html_e( 'Tour Month (Any)', 'tourpress-pack' ); ?></option>
						<?php inspiry_taxonomy_options( 'tour-month', 'month' ); ?>
                    </select>
                </div>
                <div class="form-field max-price">
                    <input type="text" name="max_price"
                           value="<?php echo ( isset( $_GET['max_price'] ) ) ? esc_attr( $_GET['max_price'] ) : ''; ?>"
                           placeholder="<?php esc_html_e( 'Maximum Price', 'tourpress-pack' ); ?>">
                </div>
                <input type="submit" value="<?php esc_html_e( 'Search', 'tourpress-pack' ); ?>">
            </form>
			<?php
		}
	}

	add_shortcode( 'inspiry_tour_search_form', 'inspiry_tour_search_form_shortcode' );
}

if ( ! function_exists( 'inspiry_contact_form_shortcode' ) ) {
	/**
	 * Contact form shortcode
	 */
	function inspiry_contact_form_shortcode() {

		$target_email = get_post_meta( get_the_ID(), 'Inspiry_Tours_form_email', true );

		?>
		<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" id="contact-form" method="post">
			<input type="text" name="fname" placeholder="<?php esc_html_e( 'First Name', 'tourpress-pack' ); ?>" title="<?php esc_html_e( '* Please enter your first name.', 'tourpress-pack' ); ?>" class="required">
			<input type="text" name="lname" placeholder="<?php esc_html_e( 'Last Name', 'tourpress-pack' ); ?>">
			<input type="text" name="phone" placeholder="<?php esc_html_e( 'Mobile', 'tourpress-pack' ); ?>">
			<input type="text" name="email" placeholder="<?php esc_html_e( 'Email', 'tourpress-pack' ); ?>" title="<?php esc_html_e( '* Please enter your correct email.', 'tourpress-pack' ); ?>" class="required email">
			<textarea name="message" cols="30" rows="10" placeholder="<?php esc_html_e( 'Message', 'tourpress-pack' ); ?>" title="<?php esc_html_e( '* Please enter your message.', 'tourpress-pack' ); ?>" class="required"></textarea>
			<div class="submission-area">
				<input type="hidden" name="action" value="inspiry_contact_request"/>
				<input type="hidden" name="nonce" value="<?php echo wp_create_nonce( 'inspiry_contact_request' ); ?>"/>
				<input type="hidden" name="target" value="<?php echo antispambot( sanitize_email( $target_email ) ); ?>">
				<input type="submit" id="submit-button" value="<?php esc_html_e( 'Submit', 'tourpress-pack' ); ?>">
				<img id="ajax-loader" src="<?php echo INPIRY_TEMPLATE_DIRECTORY_URI . 'img/ajax-loader.svg'; ?>" alt="Ajax Loader">
			</div>
		</form>
		<div id="error-container"></div>
		<div id="message-container"></div>
		<?php
	}

	add_shortcode( 'inspiry_contact_form', 'inspiry_contact_form_shortcode' );
}

if ( ! function_exists( 'inspiry_booking_form_shortcode' ) ) {
	/**
	 * Tour Booking form shortcode
	 */
	function inspiry_booking_form_shortcode() {

		$target_email = get_theme_mod( 'inspiry_booking_form_email', get_bloginfo( 'admin_email' ) );
		$form_title   = get_theme_mod( 'inspiry_booking_form_title', esc_html__( 'Book the tour', 'tourpress-pack' ) );

		?>
		<section id="inspiry_booking_widget" class="widget inspiry_booking_widget">

			<header style="
			<?php

				$background_url      = get_theme_mod( 'inspiry_tb_background_image_url' );
				$background_repeat   = get_theme_mod( 'inspiry_tb_background_repeat', 'no-repeat' );
				$background_size     = get_theme_mod( 'inspiry_tb_background_size', 'auto' );
				$background_position = get_theme_mod( 'inspiry_tb_background_position', 'center-center' );

				if ( $background_url ) {
					echo 'background-image: url(' . esc_url( $background_url ) . '); ';
				}

				if ( $background_repeat ) {
					echo 'background-repeat: ' . esc_html( $background_repeat ) . '; ';
				}

				if ( $background_size ) {
					echo 'background-size: ' . esc_html( $background_size ) . '; ';
				}

				if ( $background_position ) {
					echo 'background-position: ' . str_replace( '-', ' ', esc_html( $background_position ) ) . '; ';
				}
			?>
				">
				<span><?php include get_theme_file_path( '/img/svg/plane.svg'); ?></span>
				<h2 class="widget-title"><?php echo esc_html( $form_title ); ?></h2>
			</header>

			<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" class="tour-booking" id="contact-form" method="post">
				<p>
					<input type="text" name="name" placeholder="<?php esc_html_e( 'Name', 'tourpress-pack' ); ?>" class="required" title="<?php esc_html_e( '* Please provide your name.', 'tourpress-pack' ); ?>">
				</p>
				<p>
					<input type="text" name="email" placeholder="<?php esc_html_e( 'Email', 'tourpress-pack' ); ?>" class="email required" title="<?php esc_html_e( '* Please provide your valid email address.', 'tourpress-pack' ); ?>">
				</p>
				<p class="half">
					<input type="text" name="no_person" placeholder="<?php esc_html_e( 'No. of Person', 'tourpress-pack' ); ?>" class="required" title="<?php esc_html_e( '* Please provide number of persons.', 'tourpress-pack' ); ?>">
				</p>
				<p class="half">
					<input type="text" name="phone" placeholder="<?php esc_html_e( 'Phone', 'tourpress-pack' ); ?>">
				</p>
				<p>
					<select name="dep_date">
						<option value=""><?php esc_html_e( 'Departure Month', 'tourpress-pack' ); ?></option>
						<?php inspiry_taxonomy_options( 'tour-month', 'month' ); ?>
					</select>
				</p>
				<div class="submission-area">
					<input type="hidden" name="action" value="inspiry_booking_request"/>
					<input type="hidden" name="nonce" value="<?php echo wp_create_nonce( 'inspiry_booking_request' ); ?>"/>
					<input type="hidden" name="tour_url" value="<?php the_permalink(); ?>">
					<input type="hidden" name="target" value="<?php echo antispambot( sanitize_email( $target_email ) ); ?>">
					<input type="submit" id="submit-button" value="<?php esc_html_e( 'Book Now', 'tourpress-pack' ); ?>">
				</div>
			</form>
			<div id="error-container"></div>
			<div id="message-container"></div>
		</section>
		<?php
	}

	add_shortcode( 'inspiry_booking_form', 'inspiry_booking_form_shortcode' );
}
