<?php

if ( ! function_exists( 'inspiry_contact_request' ) ) {
	/**
	 * contact form email handler
	 * @since   1.0.0
	 * @return  void
	 */
	function inspiry_contact_request() {

		if ( isset( $_POST['email'] ) ):

			$nonce = $_POST['nonce'];

			if ( ! wp_verify_nonce( $nonce, 'inspiry_contact_request' ) ) {
				echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Unverified Nonce!', 'tourpress-pack' )
				) );
				die;
			}

			// Sanitize and Validate Target email address that is coming from agent form
			$to_email = sanitize_email( $_POST['target'] );
			$to_email = is_email( $to_email );
			if ( ! $to_email ) {
				echo wp_json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Target Email address is not properly configured!', 'tourpress-pack' )
				) );
				die;
			}

			/*
			 *  Sanitize and Validate contact form input data
			 */
			$from_name  = sanitize_text_field( $_POST['fname'] );
			$last_name  = sanitize_text_field( $_POST['lname'] );
			$phone      = sanitize_text_field( $_POST['phone'] );
			$message    = wp_kses_data( $_POST['message'] );
			$from_email = sanitize_email( $_POST['email'] );
			$from_email = is_email( $from_email );
			if ( ! $from_email ) {
				echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Provided Email address is invalid!', 'tourpress-pack' )
				) );
				die;
			}

			$email_subject = esc_html__( 'New message sent by', 'tourpress-pack' ) . ' ' . $from_name . ' ' . esc_html__( 'using contact form at', 'tourpress-pack' ) . ' ' . esc_html( get_bloginfo( 'name' ) );
			$email_body    = esc_html__( "You have received a message from: ", 'tourpress-pack' ) . $from_name . ' ' . $last_name . " <br/>";

			if ( ! empty( $phone ) ) {
				$email_body .= esc_html__( "Phone Number: ", 'tourpress-pack' ) . $phone . " <br/>";
			}

			$email_body .= esc_html__( "Their additional message is as follows:", 'tourpress-pack' ) . " <br/><br/>";
			$email_body .= wpautop( $message );
			$email_body .= wpautop( sprintf( esc_html__( 'You can contact %1$s via email: %2$s', 'tourpress-pack' ), $from_name, $from_email ) );

			/*
			 * Email Headers ( Reply To and Content Type )
			 */
			$headers   = array();
			$headers[] = "Reply-To: $from_name <$from_email>";
			$headers[] = "Content-Type: text/html; charset=UTF-8";
			$headers   = apply_filters( "inspiry_contact_mail_header", $headers );    // just in case if you want to modify the header in child theme

			if ( wp_mail( $to_email, $email_subject, $email_body, $headers ) ) {
				echo json_encode( array(
					'success' => true,
					'message' => esc_html__( "Message Sent Successfully!", 'tourpress-pack' )
				) );
			} else {
				echo json_encode( array(
						'success' => false,
						'message' => esc_html__( "Server Error: WordPress mail function failed!", 'tourpress-pack' )
					)
				);
			}

		else:
			echo json_encode( array(
					'success' => false,
					'message' => esc_html__( "Invalid Request !", 'tourpress-pack' )
				)
			);
		endif;

		die;
	}

	add_action( 'wp_ajax_nopriv_inspiry_contact_request', 'inspiry_contact_request' );
	add_action( 'wp_ajax_inspiry_contact_request', 'inspiry_contact_request' );
}

if ( ! function_exists( 'inspiry_booking_request' ) ) {
	/**
	 * contact form email handler
	 * @since   1.0.0
	 * @return  void
	 */
	function inspiry_booking_request() {

		if ( isset( $_POST['email'] ) ):

			$nonce = $_POST['nonce'];

			if ( ! wp_verify_nonce( $nonce, 'inspiry_booking_request' ) ) {
				echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Unverified Nonce!', 'tourpress-pack' )
				) );
				die;
			}

			// Sanitize and Validate Target email address that is coming from agent form
			$to_email = sanitize_email( $_POST['target'] );
			$to_email = is_email( $to_email );
			if ( ! $to_email ) {
				echo wp_json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Target Email address is not properly configured!', 'tourpress-pack' )
				) );
				die;
			}

			/*
			 *  Sanitize and Validate contact form input data
			 */
			$from_name = sanitize_text_field( $_POST['name'] );
			$no_person = sanitize_text_field( $_POST['no_person'] );
			$phone     = sanitize_text_field( $_POST['phone'] );
			$dep_date  = sanitize_text_field( $_POST['dep_date'] );
			$tour_url  = esc_url( $_POST['tour_url'] );

			$from_email = sanitize_email( $_POST['email'] );
			$from_email = is_email( $from_email );
			if ( ! $from_email ) {
				echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Provided Email address is invalid!', 'tourpress-pack' )
				) );
				die;
			}

			$email_subject = esc_html__( 'New booking request sent by', 'tourpress-pack' ) . ' ' . $from_name . ' ' . esc_html__( 'using booking form at', 'tourpress-pack' ) . ' ' . esc_html( get_bloginfo( 'name' ) );
			$email_body    = esc_html__( "You have received a message from: ", 'tourpress-pack' ) . $from_name . " <br/>";

			if ( ! empty( $tour_url ) ) {
				$email_body .= esc_html__( "Tour URL: ", 'tourpress-pack' ) . $tour_url . " <br/>";
			}

			if ( ! empty( $phone ) ) {
				$email_body .= esc_html__( "Phone Number: ", 'tourpress-pack' ) . $phone . " <br/>";
			}

			if ( ! empty( $no_person ) ) {
				$email_body .= esc_html__( "No. of Person: ", 'tourpress-pack' ) . $no_person . " <br/>";
			}

			if ( ! empty( $dep_date ) ) {
				$email_body .= esc_html__( "Departure Month: ", 'tourpress-pack' ) . ucfirst( $dep_date ) . " <br/>";
			}

			$email_body .= wpautop( sprintf( esc_html__( 'You can contact %1$s via email: %2$s', 'tourpress-pack' ), $from_name, $from_email ) );

			/*
			 * Email Headers ( Reply To and Content Type )
			 */
			$headers   = array();
			$headers[] = "Reply-To: $from_name <$from_email>";
			$headers[] = "Content-Type: text/html; charset=UTF-8";
			$headers   = apply_filters( "inspiry_contact_mail_header", $headers );    // just in case if you want to modify the header in child theme

			if ( wp_mail( $to_email, $email_subject, $email_body, $headers ) ) {
				echo json_encode( array(
					'success' => true,
					'message' => esc_html__( "Booking Request Sent Successfully!", 'tourpress-pack' )
				) );
			} else {
				echo json_encode( array(
						'success' => false,
						'message' => esc_html__( "Server Error: WordPress mail function failed!", 'tourpress-pack' )
					)
				);
			}

		else:
			echo json_encode( array(
					'success' => false,
					'message' => esc_html__( "Invalid Request !", 'tourpress-pack' )
				)
			);
		endif;

		die;
	}

	add_action( 'wp_ajax_nopriv_inspiry_booking_request', 'inspiry_booking_request' );
	add_action( 'wp_ajax_inspiry_booking_request', 'inspiry_booking_request' );
}