<?php
add_action( 'widgets_init', function () {
	register_widget( 'Inspiry_Share_Widget' );
} );

if ( ! class_exists( 'Inspiry_Share_Widget' ) ) {
	class Inspiry_Share_Widget extends WP_Widget {

		/**
		 * Sets up the widgets name etc
		 */
		public function __construct() {
			$widget_ops = array(
				'classname'   => 'inspiry_share_widget',
				'description' => esc_html__( 'Display social share buttons.', 'inspiry-tourpress' ),
			);

			parent::__construct( 'inspiry_share_widget', esc_html__( 'Inspiry - Social Share', 'inspiry-tourpress' ), $widget_ops );
		}


		/**
		 * Outputs the content of the widget
		 *
		 * @param array $args
		 * @param array $instance
		 */
		public function widget( $args, $instance ) {
			// outputs the content of the widget
			echo wp_kses( $args['before_widget'], inspiry_widget_wrap_allowed_tags() );

			if ( ! empty( $instance['title'] ) ) {
				echo wp_kses(
					$args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'],
					inspiry_widget_heading_allowed_tags()
				);
			}

			?>
			<div class="social-share">

				<ul class="social-buttons clearfix">
					<li class="facebook">
						<a href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>&amp;t=<?php echo urlencode( get_the_title() ); ?>" target="_blank" title="<?php esc_html_e( 'Share on Facebook!', 'inspiry-tourpress' ); ?>">
							<i class="fa fa-facebook" aria-hidden="true"></i> </a>
					</li>
					<li class="twitter">
						<?php $twitter_status = get_the_title() . ' - ' . get_the_permalink(); ?>
						<a href="http://twitter.com/home/?status=<?php echo urlencode( $twitter_status ); ?>" target="_blank" title="<?php esc_html_e( 'Tweet this!', 'inspiry-tourpress' ); ?>">
							<i class="fa fa-twitter" aria-hidden="true"></i> </a>
					</li>
					<li class="pinterest">
						<a href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php $url = wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) ); echo esc_url( $url ); ?>" target="_blank" title="<?php esc_html_e( 'Pin this!', 'inspiry-tourpress' ); ?>">
							<i class="fa fa-pinterest-p" aria-hidden="true"></i> </a>
					</li>
				</ul>
			</div>
			<?php

			echo wp_kses( $args['after_widget'], inspiry_widget_wrap_allowed_tags() );
		}


		/**
		 * Outputs the options form on admin
		 *
		 * @param array $instance The widget options
		 *
		 * @return void
		 */
		public function form( $instance ) {
			// outputs the options form on admin
			$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'Share with others', 'inspiry-tourpress' );
			?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'inspiry-tourpress' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_html( $title ); ?>">
			</p>
			<?php
		}


		/**
		 * Processing widget options on save
		 *
		 * @param array $new_instance The new options
		 * @param array $old_instance The previous options
		 *
		 * @return array
		 */
		public function update( $new_instance, $old_instance ) {

			$updated_instance = array();

			// processes widget options to be saved
			foreach ( $new_instance as $key => $value ) {
				$updated_instance[ $key ] = sanitize_text_field( $value );
			}

			return $updated_instance;
		}
	}
}
