<?php
add_action( 'widgets_init', function () {
	register_widget( 'Inspiry_Address_Widget' );
} );

class Inspiry_Address_Widget extends WP_Widget {

	/**
	 * Sets up the widgets name etc
	 */
	public function __construct() {
		$widget_ops = array(
			'classname'   => 'inspiry_address_widget',
			'description' => esc_html__( 'Display address, email and phone number.', 'inspiry-tourpress' ),
		);

		parent::__construct( 'inspiry_address_widget', esc_html__( 'Inspiry - Address & Contact', 'inspiry-tourpress' ), $widget_ops );
	}

	/**
	 * Outputs the content of the widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		// outputs the content of the widget
		echo wp_kses( $args['before_widget'], inspiry_widget_wrap_allowed_tags() );

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses(
				$args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'],
				inspiry_widget_heading_allowed_tags()
			);
		}

		if ( ! empty( $instance['address'] ) ) {
			echo '<p class="address">' . esc_html( $instance['address'] ) . '</p>';
		}

		if ( ! empty( $instance['email'] ) ) {
			echo '<p class="email"><i class="fa fa-envelope-o" aria-hidden="true"></i><a href="mailto:' . antispambot( sanitize_email( $instance['email'] ) ) . '">' . antispambot( sanitize_email( $instance['email'] ) ) . '</a></p>';
		}

		if ( ! empty( $instance['phone'] ) ) {
			echo '<p class="phone">';
			include get_theme_file_path( '/img/svg/call.svg' );
			echo '<a href="tel:' . str_replace( ' ', '', esc_attr( $instance['phone'] ) ) . '">' . esc_html( $instance['phone'] ) . '</a>';
		}

		echo wp_kses( $args['after_widget'], inspiry_widget_wrap_allowed_tags() );
	}

	/**
	 * Outputs the options form on admin
	 *
	 * @param array $instance The widget options
	 *
	 * @return void
	 */
	public function form( $instance ) {
		// outputs the options form on admin
		$title   = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'Address', 'inspiry-tourpress' );
		$address = ! empty( $instance['address'] ) ? $instance['address'] : '';
		$phone   = ! empty( $instance['phone'] ) ? $instance['phone'] : '';
		$email   = ! empty( $instance['email'] ) ? $instance['email'] : '';
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'inspiry-tourpress' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_html( $title ); ?>">
		</p>        <p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>"><?php esc_html_e( 'Address:', 'inspiry-tourpress' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'address' ) ); ?>" type="text" value="<?php echo esc_html( $address ); ?>">
		</p>        <p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>"><?php esc_html_e( 'Email:', 'inspiry-tourpress' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'email' ) ); ?>" type="text" value="<?php echo esc_html( $email ); ?>">
		</p>        <p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>"><?php esc_html_e( 'Phone:', 'inspiry-tourpress' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'phone' ) ); ?>" type="text" value="<?php echo esc_html( $phone ); ?>">
		</p>
		<?php
	}

	/**
	 * Processing widget options on save
	 *
	 * @param array $new_instance The new options
	 * @param array $old_instance The previous options
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ) {

		$updated_instance = array();

		// processes widget options to be saved
		foreach ( $new_instance as $key => $value ) {
			$updated_instance[ $key ] = sanitize_text_field( $value );
		}

		return $updated_instance;
	}
}