<?php

/**
 * The class responsible for providing testimonials custom post type and related stuff.
 */
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-inspiry-testimonial-post-type.php';

/**
 * The file responsible for providing shortcodes.
 */
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/shortcodes.php';

/**
 * The file responsible for providing mail handler.
 */
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/mail-handler.php';

/**
 * The file responsible for social share buttons in different areas across the theme.
 */
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/social-share.php';


/**
 * Custom Post Types registration
 */

// Testimonial Post Type
$testimonial_post_type = new Inspiry_Testimonial_Post_Type();
add_action( 'init', array( $testimonial_post_type, 'register_testimonial_post_type' ) );
add_action( 'enter_title_here', array( $testimonial_post_type, 'change_title_text' ) );
add_filter( 'rwmb_meta_boxes', array( $testimonial_post_type, 'register_meta_boxes' ) );
add_filter( 'manage_testimonial_posts_columns', array( $testimonial_post_type, 'update_columns' ) );
add_filter( 'manage_testimonial_posts_custom_column', array( $testimonial_post_type, 'manage_columns_contents' ), 10, 2  );

/**
 * Widgets registration
 */
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/widgets/inspiry-address-contact.php';
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/widgets/inspiry-recent-posts.php';
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/widgets/inspiry-social-share.php';