<?php
 namespace MailPoetVendor\Twig\TokenParser; if (!defined('ABSPATH')) exit; use MailPoetVendor\Twig\Error\SyntaxError; use MailPoetVendor\Twig\Node\Expression\AssignNameExpression; use MailPoetVendor\Twig\Node\Expression\ConstantExpression; use MailPoetVendor\Twig\Node\Expression\GetAttrExpression; use MailPoetVendor\Twig\Node\Expression\NameExpression; use MailPoetVendor\Twig\Node\ForNode; use MailPoetVendor\Twig\Node\Node; use MailPoetVendor\Twig\Token; use MailPoetVendor\Twig\TokenStream; final class ForTokenParser extends \MailPoetVendor\Twig\TokenParser\AbstractTokenParser { public function parse(\MailPoetVendor\Twig\Token $token) { $lineno = $token->getLine(); $stream = $this->parser->getStream(); $targets = $this->parser->getExpressionParser()->parseAssignmentExpression(); $stream->expect( 8, 'in' ); $seq = $this->parser->getExpressionParser()->parseExpression(); $ifexpr = null; if ($stream->nextIf( 5, 'if' )) { @\trigger_error(\sprintf('Using an "if" condition on "for" tag in "%s" at line %d is deprecated since Twig 2.10.0, use a "filter" filter or an "if" condition inside the "for" body instead (if your condition depends on a variable updated inside the loop).', $stream->getSourceContext()->getName(), $lineno), \E_USER_DEPRECATED); $ifexpr = $this->parser->getExpressionParser()->parseExpression(); } $stream->expect( 3 ); $body = $this->parser->subparse([$this, 'decideForFork']); if ('else' == $stream->next()->getValue()) { $stream->expect( 3 ); $else = $this->parser->subparse([$this, 'decideForEnd'], \true); } else { $else = null; } $stream->expect( 3 ); if (\count($targets) > 1) { $keyTarget = $targets->getNode(0); $keyTarget = new \MailPoetVendor\Twig\Node\Expression\AssignNameExpression($keyTarget->getAttribute('name'), $keyTarget->getTemplateLine()); $valueTarget = $targets->getNode(1); $valueTarget = new \MailPoetVendor\Twig\Node\Expression\AssignNameExpression($valueTarget->getAttribute('name'), $valueTarget->getTemplateLine()); } else { $keyTarget = new \MailPoetVendor\Twig\Node\Expression\AssignNameExpression('_key', $lineno); $valueTarget = $targets->getNode(0); $valueTarget = new \MailPoetVendor\Twig\Node\Expression\AssignNameExpression($valueTarget->getAttribute('name'), $valueTarget->getTemplateLine()); } if ($ifexpr) { $this->checkLoopUsageCondition($stream, $ifexpr); $this->checkLoopUsageBody($stream, $body); } return new \MailPoetVendor\Twig\Node\ForNode($keyTarget, $valueTarget, $seq, $ifexpr, $body, $else, $lineno, $this->getTag()); } public function decideForFork(\MailPoetVendor\Twig\Token $token) { return $token->test(['else', 'endfor']); } public function decideForEnd(\MailPoetVendor\Twig\Token $token) { return $token->test('endfor'); } private function checkLoopUsageCondition(\MailPoetVendor\Twig\TokenStream $stream, \MailPoetVendor\Twig\Node\Node $node) { if ($node instanceof \MailPoetVendor\Twig\Node\Expression\GetAttrExpression && $node->getNode('node') instanceof \MailPoetVendor\Twig\Node\Expression\NameExpression && 'loop' == $node->getNode('node')->getAttribute('name')) { throw new \MailPoetVendor\Twig\Error\SyntaxError('The "loop" variable cannot be used in a looping condition.', $node->getTemplateLine(), $stream->getSourceContext()); } foreach ($node as $n) { if (!$n) { continue; } $this->checkLoopUsageCondition($stream, $n); } } private function checkLoopUsageBody(\MailPoetVendor\Twig\TokenStream $stream, \MailPoetVendor\Twig\Node\Node $node) { if ($node instanceof \MailPoetVendor\Twig\Node\Expression\GetAttrExpression && $node->getNode('node') instanceof \MailPoetVendor\Twig\Node\Expression\NameExpression && 'loop' == $node->getNode('node')->getAttribute('name')) { $attribute = $node->getNode('attribute'); if ($attribute instanceof \MailPoetVendor\Twig\Node\Expression\ConstantExpression && \in_array($attribute->getAttribute('value'), ['length', 'revindex0', 'revindex', 'last'])) { throw new \MailPoetVendor\Twig\Error\SyntaxError(\sprintf('The "loop.%s" variable is not defined when looping with a condition.', $attribute->getAttribute('value')), $node->getTemplateLine(), $stream->getSourceContext()); } } if ($node instanceof \MailPoetVendor\Twig\Node\ForNode) { return; } foreach ($node as $n) { if (!$n) { continue; } $this->checkLoopUsageBody($stream, $n); } } public function getTag() { return 'for'; } } \class_alias('MailPoetVendor\\Twig\\TokenParser\\ForTokenParser', 'MailPoetVendor\\Twig_TokenParser_For'); 