<?php
 namespace MailPoetVendor\Twig; if (!defined('ABSPATH')) exit; use MailPoetVendor\Twig\Error\SyntaxError; use MailPoetVendor\Twig\Node\BlockNode; use MailPoetVendor\Twig\Node\BlockReferenceNode; use MailPoetVendor\Twig\Node\BodyNode; use MailPoetVendor\Twig\Node\Expression\AbstractExpression; use MailPoetVendor\Twig\Node\MacroNode; use MailPoetVendor\Twig\Node\ModuleNode; use MailPoetVendor\Twig\Node\Node; use MailPoetVendor\Twig\Node\NodeCaptureInterface; use MailPoetVendor\Twig\Node\NodeOutputInterface; use MailPoetVendor\Twig\Node\PrintNode; use MailPoetVendor\Twig\Node\SpacelessNode; use MailPoetVendor\Twig\Node\TextNode; use MailPoetVendor\Twig\TokenParser\TokenParserInterface; class Parser { private $stack = []; private $stream; private $parent; private $handlers; private $visitors; private $expressionParser; private $blocks; private $blockStack; private $macros; private $env; private $importedSymbols; private $traits; private $embeddedTemplates = []; private $varNameSalt = 0; public function __construct(\MailPoetVendor\Twig\Environment $env) { $this->env = $env; } public function getVarName() { return \sprintf('__internal_%s', \hash('sha256', __METHOD__ . $this->stream->getSourceContext()->getCode() . $this->varNameSalt++)); } public function parse(\MailPoetVendor\Twig\TokenStream $stream, $test = null, $dropNeedle = \false) { $vars = \get_object_vars($this); unset($vars['stack'], $vars['env'], $vars['handlers'], $vars['visitors'], $vars['expressionParser'], $vars['reservedMacroNames']); $this->stack[] = $vars; if (null === $this->handlers) { $this->handlers = []; foreach ($this->env->getTokenParsers() as $handler) { $handler->setParser($this); $this->handlers[$handler->getTag()] = $handler; } } if (null === $this->visitors) { $this->visitors = $this->env->getNodeVisitors(); } if (null === $this->expressionParser) { $this->expressionParser = new \MailPoetVendor\Twig\ExpressionParser($this, $this->env); } $this->stream = $stream; $this->parent = null; $this->blocks = []; $this->macros = []; $this->traits = []; $this->blockStack = []; $this->importedSymbols = [[]]; $this->embeddedTemplates = []; $this->varNameSalt = 0; try { $body = $this->subparse($test, $dropNeedle); if (null !== $this->parent && null === ($body = $this->filterBodyNodes($body))) { $body = new \MailPoetVendor\Twig\Node\Node(); } } catch (\MailPoetVendor\Twig\Error\SyntaxError $e) { if (!$e->getSourceContext()) { $e->setSourceContext($this->stream->getSourceContext()); } if (!$e->getTemplateLine()) { $e->setTemplateLine($this->stream->getCurrent()->getLine()); } throw $e; } $node = new \MailPoetVendor\Twig\Node\ModuleNode(new \MailPoetVendor\Twig\Node\BodyNode([$body]), $this->parent, new \MailPoetVendor\Twig\Node\Node($this->blocks), new \MailPoetVendor\Twig\Node\Node($this->macros), new \MailPoetVendor\Twig\Node\Node($this->traits), $this->embeddedTemplates, $stream->getSourceContext()); $traverser = new \MailPoetVendor\Twig\NodeTraverser($this->env, $this->visitors); $node = $traverser->traverse($node); foreach (\array_pop($this->stack) as $key => $val) { $this->{$key} = $val; } return $node; } public function subparse($test, $dropNeedle = \false) { $lineno = $this->getCurrentToken()->getLine(); $rv = []; while (!$this->stream->isEOF()) { switch ($this->getCurrentToken()->getType()) { case 0: $token = $this->stream->next(); $rv[] = new \MailPoetVendor\Twig\Node\TextNode($token->getValue(), $token->getLine()); break; case 2: $token = $this->stream->next(); $expr = $this->expressionParser->parseExpression(); $this->stream->expect( 4 ); $rv[] = new \MailPoetVendor\Twig\Node\PrintNode($expr, $token->getLine()); break; case 1: $this->stream->next(); $token = $this->getCurrentToken(); if (5 !== $token->getType()) { throw new \MailPoetVendor\Twig\Error\SyntaxError('A block must start with a tag name.', $token->getLine(), $this->stream->getSourceContext()); } if (null !== $test && $test($token)) { if ($dropNeedle) { $this->stream->next(); } if (1 === \count($rv)) { return $rv[0]; } return new \MailPoetVendor\Twig\Node\Node($rv, [], $lineno); } if (!isset($this->handlers[$token->getValue()])) { if (null !== $test) { $e = new \MailPoetVendor\Twig\Error\SyntaxError(\sprintf('Unexpected "%s" tag', $token->getValue()), $token->getLine(), $this->stream->getSourceContext()); if (\is_array($test) && isset($test[0]) && $test[0] instanceof \MailPoetVendor\Twig\TokenParser\TokenParserInterface) { $e->appendMessage(\sprintf(' (expecting closing tag for the "%s" tag defined near line %s).', $test[0]->getTag(), $lineno)); } } else { $e = new \MailPoetVendor\Twig\Error\SyntaxError(\sprintf('Unknown "%s" tag.', $token->getValue()), $token->getLine(), $this->stream->getSourceContext()); $e->addSuggestions($token->getValue(), \array_keys($this->env->getTags())); } throw $e; } $this->stream->next(); $subparser = $this->handlers[$token->getValue()]; $node = $subparser->parse($token); if (null !== $node) { $rv[] = $node; } break; default: throw new \MailPoetVendor\Twig\Error\SyntaxError('Lexer or parser ended up in unsupported state.', $this->getCurrentToken()->getLine(), $this->stream->getSourceContext()); } } if (1 === \count($rv)) { return $rv[0]; } return new \MailPoetVendor\Twig\Node\Node($rv, [], $lineno); } public function getBlockStack() { return $this->blockStack; } public function peekBlockStack() { return isset($this->blockStack[\count($this->blockStack) - 1]) ? $this->blockStack[\count($this->blockStack) - 1] : null; } public function popBlockStack() { \array_pop($this->blockStack); } public function pushBlockStack($name) { $this->blockStack[] = $name; } public function hasBlock($name) { return isset($this->blocks[$name]); } public function getBlock($name) { return $this->blocks[$name]; } public function setBlock($name, \MailPoetVendor\Twig\Node\BlockNode $value) { $this->blocks[$name] = new \MailPoetVendor\Twig\Node\BodyNode([$value], [], $value->getTemplateLine()); } public function hasMacro($name) { return isset($this->macros[$name]); } public function setMacro($name, \MailPoetVendor\Twig\Node\MacroNode $node) { $this->macros[$name] = $node; } public function isReservedMacroName($name) { @\trigger_error(\sprintf('The "%s" method is deprecated since Twig 2.7 and will be removed in 3.0.', __METHOD__), \E_USER_DEPRECATED); return \false; } public function addTrait($trait) { $this->traits[] = $trait; } public function hasTraits() { return \count($this->traits) > 0; } public function embedTemplate(\MailPoetVendor\Twig\Node\ModuleNode $template) { $template->setIndex(\mt_rand()); $this->embeddedTemplates[] = $template; } public function addImportedSymbol($type, $alias, $name = null, \MailPoetVendor\Twig\Node\Expression\AbstractExpression $node = null) { $this->importedSymbols[0][$type][$alias] = ['name' => $name, 'node' => $node]; } public function getImportedSymbol($type, $alias) { return $this->importedSymbols[0][$type][$alias] ?? $this->importedSymbols[\count($this->importedSymbols) - 1][$type][$alias] ?? null; } public function isMainScope() { return 1 === \count($this->importedSymbols); } public function pushLocalScope() { \array_unshift($this->importedSymbols, []); } public function popLocalScope() { \array_shift($this->importedSymbols); } public function getExpressionParser() { return $this->expressionParser; } public function getParent() { return $this->parent; } public function setParent($parent) { $this->parent = $parent; } public function getStream() { return $this->stream; } public function getCurrentToken() { return $this->stream->getCurrent(); } private function filterBodyNodes(\MailPoetVendor\Twig\Node\Node $node, bool $nested = \false) { if ($node instanceof \MailPoetVendor\Twig\Node\TextNode && !\ctype_space($node->getAttribute('data')) || !$node instanceof \MailPoetVendor\Twig\Node\TextNode && !$node instanceof \MailPoetVendor\Twig\Node\BlockReferenceNode && ($node instanceof \MailPoetVendor\Twig\Node\NodeOutputInterface && !$node instanceof \MailPoetVendor\Twig\Node\SpacelessNode)) { if (\false !== \strpos((string) $node, \chr(0xef) . \chr(0xbb) . \chr(0xbf))) { $t = \substr($node->getAttribute('data'), 3); if ('' === $t || \ctype_space($t)) { return; } } throw new \MailPoetVendor\Twig\Error\SyntaxError('A template that extends another one cannot include content outside Twig blocks. Did you forget to put the content inside a {% block %} tag?', $node->getTemplateLine(), $this->stream->getSourceContext()); } if ($node instanceof \MailPoetVendor\Twig\Node\NodeCaptureInterface) { return $node; } if (!$nested && $node instanceof \MailPoetVendor\Twig\Node\SpacelessNode) { @\trigger_error(\sprintf('Using the spaceless tag at the root level of a child template in "%s" at line %d is deprecated since Twig 2.5.0 and will become a syntax error in 3.0.', $this->stream->getSourceContext()->getName(), $node->getTemplateLine()), \E_USER_DEPRECATED); } if ($nested && ($node instanceof \MailPoetVendor\Twig\Node\BlockReferenceNode || $node instanceof \MailPoetVendor\Twig_Node_BlockReference)) { @\trigger_error(\sprintf('Nesting a block definition under a non-capturing node in "%s" at line %d is deprecated since Twig 2.5.0 and will become a syntax error in 3.0.', $this->stream->getSourceContext()->getName(), $node->getTemplateLine()), \E_USER_DEPRECATED); return; } if ($node instanceof \MailPoetVendor\Twig\Node\NodeOutputInterface && !$node instanceof \MailPoetVendor\Twig\Node\SpacelessNode) { return; } $nested = $nested || 'Twig_Node' !== \get_class($node) && \MailPoetVendor\Twig\Node\Node::class !== \get_class($node); foreach ($node as $k => $n) { if (null !== $n && null === $this->filterBodyNodes($n, $nested)) { $node->removeNode($k); } } return $node; } } \class_alias('MailPoetVendor\\Twig\\Parser', 'MailPoetVendor\\Twig_Parser'); 