<?php
 namespace MailPoetVendor\Twig\NodeVisitor; if (!defined('ABSPATH')) exit; use MailPoetVendor\Twig\Environment; use MailPoetVendor\Twig\Node\Expression\BlockReferenceExpression; use MailPoetVendor\Twig\Node\Expression\ConditionalExpression; use MailPoetVendor\Twig\Node\Expression\ConstantExpression; use MailPoetVendor\Twig\Node\Expression\FilterExpression; use MailPoetVendor\Twig\Node\Expression\FunctionExpression; use MailPoetVendor\Twig\Node\Expression\GetAttrExpression; use MailPoetVendor\Twig\Node\Expression\MethodCallExpression; use MailPoetVendor\Twig\Node\Expression\NameExpression; use MailPoetVendor\Twig\Node\Expression\ParentExpression; use MailPoetVendor\Twig\Node\Node; final class SafeAnalysisNodeVisitor extends \MailPoetVendor\Twig\NodeVisitor\AbstractNodeVisitor { private $data = []; private $safeVars = []; public function setSafeVars($safeVars) { $this->safeVars = $safeVars; } public function getSafe(\MailPoetVendor\Twig\Node\Node $node) { $hash = \spl_object_hash($node); if (!isset($this->data[$hash])) { return; } foreach ($this->data[$hash] as $bucket) { if ($bucket['key'] !== $node) { continue; } if (\in_array('html_attr', $bucket['value'])) { $bucket['value'][] = 'html'; } return $bucket['value']; } } private function setSafe(\MailPoetVendor\Twig\Node\Node $node, array $safe) { $hash = \spl_object_hash($node); if (isset($this->data[$hash])) { foreach ($this->data[$hash] as &$bucket) { if ($bucket['key'] === $node) { $bucket['value'] = $safe; return; } } } $this->data[$hash][] = ['key' => $node, 'value' => $safe]; } protected function doEnterNode(\MailPoetVendor\Twig\Node\Node $node, \MailPoetVendor\Twig\Environment $env) { return $node; } protected function doLeaveNode(\MailPoetVendor\Twig\Node\Node $node, \MailPoetVendor\Twig\Environment $env) { if ($node instanceof \MailPoetVendor\Twig\Node\Expression\ConstantExpression) { $this->setSafe($node, ['all']); } elseif ($node instanceof \MailPoetVendor\Twig\Node\Expression\BlockReferenceExpression) { $this->setSafe($node, ['all']); } elseif ($node instanceof \MailPoetVendor\Twig\Node\Expression\ParentExpression) { $this->setSafe($node, ['all']); } elseif ($node instanceof \MailPoetVendor\Twig\Node\Expression\ConditionalExpression) { $safe = $this->intersectSafe($this->getSafe($node->getNode('expr2')), $this->getSafe($node->getNode('expr3'))); $this->setSafe($node, $safe); } elseif ($node instanceof \MailPoetVendor\Twig\Node\Expression\FilterExpression) { $name = $node->getNode('filter')->getAttribute('value'); $args = $node->getNode('arguments'); if (\false !== ($filter = $env->getFilter($name))) { $safe = $filter->getSafe($args); if (null === $safe) { $safe = $this->intersectSafe($this->getSafe($node->getNode('node')), $filter->getPreservesSafety()); } $this->setSafe($node, $safe); } else { $this->setSafe($node, []); } } elseif ($node instanceof \MailPoetVendor\Twig\Node\Expression\FunctionExpression) { $name = $node->getAttribute('name'); $args = $node->getNode('arguments'); $function = $env->getFunction($name); if (\false !== $function) { $this->setSafe($node, $function->getSafe($args)); } else { $this->setSafe($node, []); } } elseif ($node instanceof \MailPoetVendor\Twig\Node\Expression\MethodCallExpression) { if ($node->getAttribute('safe')) { $this->setSafe($node, ['all']); } else { $this->setSafe($node, []); } } elseif ($node instanceof \MailPoetVendor\Twig\Node\Expression\GetAttrExpression && $node->getNode('node') instanceof \MailPoetVendor\Twig\Node\Expression\NameExpression) { $name = $node->getNode('node')->getAttribute('name'); if (\in_array($name, $this->safeVars)) { $this->setSafe($node, ['all']); } else { $this->setSafe($node, []); } } else { $this->setSafe($node, []); } return $node; } private function intersectSafe(array $a = null, array $b = null) : array { if (null === $a || null === $b) { return []; } if (\in_array('all', $a)) { return $b; } if (\in_array('all', $b)) { return $a; } return \array_intersect($a, $b); } public function getPriority() { return 0; } } \class_alias('MailPoetVendor\\Twig\\NodeVisitor\\SafeAnalysisNodeVisitor', 'MailPoetVendor\\Twig_NodeVisitor_SafeAnalysis'); 