<?php
 namespace MailPoetVendor\Twig\Node; if (!defined('ABSPATH')) exit; use MailPoetVendor\Twig\Compiler; use MailPoetVendor\Twig\Node\Expression\AbstractExpression; class IncludeNode extends \MailPoetVendor\Twig\Node\Node implements \MailPoetVendor\Twig\Node\NodeOutputInterface { public function __construct(\MailPoetVendor\Twig\Node\Expression\AbstractExpression $expr, ?\MailPoetVendor\Twig\Node\Expression\AbstractExpression $variables, bool $only, bool $ignoreMissing, int $lineno, string $tag = null) { $nodes = ['expr' => $expr]; if (null !== $variables) { $nodes['variables'] = $variables; } parent::__construct($nodes, ['only' => (bool) $only, 'ignore_missing' => (bool) $ignoreMissing], $lineno, $tag); } public function compile(\MailPoetVendor\Twig\Compiler $compiler) { $compiler->addDebugInfo($this); if ($this->getAttribute('ignore_missing')) { $template = $compiler->getVarName(); $compiler->write(\sprintf("\$%s = null;\n", $template))->write("try {\n")->indent()->write(\sprintf('$%s = ', $template)); $this->addGetTemplate($compiler); $compiler->raw(";\n")->outdent()->write("} catch (LoaderError \$e) {\n")->indent()->write("// ignore missing template\n")->outdent()->write("}\n")->write(\sprintf("if (\$%s) {\n", $template))->indent()->write(\sprintf('$%s->display(', $template)); $this->addTemplateArguments($compiler); $compiler->raw(");\n")->outdent()->write("}\n"); } else { $this->addGetTemplate($compiler); $compiler->raw('->display('); $this->addTemplateArguments($compiler); $compiler->raw(");\n"); } } protected function addGetTemplate(\MailPoetVendor\Twig\Compiler $compiler) { $compiler->write('$this->loadTemplate(')->subcompile($this->getNode('expr'))->raw(', ')->repr($this->getTemplateName())->raw(', ')->repr($this->getTemplateLine())->raw(')'); } protected function addTemplateArguments(\MailPoetVendor\Twig\Compiler $compiler) { if (!$this->hasNode('variables')) { $compiler->raw(\false === $this->getAttribute('only') ? '$context' : '[]'); } elseif (\false === $this->getAttribute('only')) { $compiler->raw('twig_array_merge($context, ')->subcompile($this->getNode('variables'))->raw(')'); } else { $compiler->raw('twig_to_array('); $compiler->subcompile($this->getNode('variables')); $compiler->raw(')'); } } } \class_alias('MailPoetVendor\\Twig\\Node\\IncludeNode', 'MailPoetVendor\\Twig_Node_Include'); 