<?php
 namespace MailPoetVendor\Egulias\EmailValidator\Validation; if (!defined('ABSPATH')) exit; use MailPoetVendor\Egulias\EmailValidator\EmailLexer; use MailPoetVendor\Egulias\EmailValidator\Exception\InvalidEmail; use MailPoetVendor\Egulias\EmailValidator\Exception\LocalOrReservedDomain; use MailPoetVendor\Egulias\EmailValidator\Exception\DomainAcceptsNoMail; use MailPoetVendor\Egulias\EmailValidator\Warning\NoDNSMXRecord; use MailPoetVendor\Egulias\EmailValidator\Exception\NoDNSRecord; class DNSCheckValidation implements \MailPoetVendor\Egulias\EmailValidator\Validation\EmailValidation { private $warnings = []; private $error; private $mxRecords = []; public function __construct() { if (!\function_exists('idn_to_ascii')) { throw new \LogicException(\sprintf('The %s class requires the Intl extension.', __CLASS__)); } } public function isValid($email, \MailPoetVendor\Egulias\EmailValidator\EmailLexer $emailLexer) { $host = $email; if (\false !== ($lastAtPos = \strrpos($email, '@'))) { $host = \substr($email, $lastAtPos + 1); } $hostParts = \explode('.', $host); $reservedTopLevelDnsNames = [ 'test', 'example', 'invalid', 'localhost', 'local', 'intranet', 'internal', 'private', 'corp', 'home', 'lan', ]; $isLocalDomain = \count($hostParts) <= 1; $isReservedTopLevel = \in_array($hostParts[\count($hostParts) - 1], $reservedTopLevelDnsNames, \true); if ($isLocalDomain || $isReservedTopLevel) { $this->error = new \MailPoetVendor\Egulias\EmailValidator\Exception\LocalOrReservedDomain(); return \false; } return $this->checkDns($host); } public function getError() { return $this->error; } public function getWarnings() { return $this->warnings; } protected function checkDns($host) { $variant = \INTL_IDNA_VARIANT_UTS46; $host = \rtrim(\idn_to_ascii($host, \IDNA_DEFAULT, $variant), '.') . '.'; return $this->validateDnsRecords($host); } private function validateDnsRecords($host) { $dnsRecords = @\dns_get_record($host, \DNS_MX + \DNS_A + \DNS_AAAA); if (empty($dnsRecords)) { $this->error = new \MailPoetVendor\Egulias\EmailValidator\Exception\NoDNSRecord(); return \false; } foreach ($dnsRecords as $dnsRecord) { if (!$this->validateMXRecord($dnsRecord)) { return \false; } } if (empty($this->mxRecords)) { $this->warnings[\MailPoetVendor\Egulias\EmailValidator\Warning\NoDNSMXRecord::CODE] = new \MailPoetVendor\Egulias\EmailValidator\Warning\NoDNSMXRecord(); } return \true; } private function validateMxRecord($dnsRecord) { if ($dnsRecord['type'] !== 'MX') { return \true; } if (empty($dnsRecord['target']) || $dnsRecord['target'] === '.') { $this->error = new \MailPoetVendor\Egulias\EmailValidator\Exception\DomainAcceptsNoMail(); return \false; } $this->mxRecords[] = $dnsRecord; return \true; } } 