<?php
 namespace MailPoetVendor\Doctrine\ORM\Tools\Pagination; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Types\Type; use MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo; use MailPoetVendor\Doctrine\ORM\Query; use MailPoetVendor\Doctrine\ORM\Query\AST\Functions\IdentityFunction; use MailPoetVendor\Doctrine\ORM\Query\AST\Node; use MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression; use MailPoetVendor\Doctrine\ORM\Query\AST\SelectExpression; use MailPoetVendor\Doctrine\ORM\Query\AST\SelectStatement; use MailPoetVendor\Doctrine\ORM\Query\TreeWalkerAdapter; use RuntimeException; use function count; use function is_string; use function reset; class LimitSubqueryWalker extends \MailPoetVendor\Doctrine\ORM\Query\TreeWalkerAdapter { public const IDENTIFIER_TYPE = 'doctrine_paginator.id.type'; public const FORCE_DBAL_TYPE_CONVERSION = 'doctrine_paginator.scalar_result.force_dbal_type_conversion'; private $_aliasCounter = 0; public function walkSelectStatement(\MailPoetVendor\Doctrine\ORM\Query\AST\SelectStatement $AST) { $queryComponents = $this->_getQueryComponents(); $from = $AST->fromClause->identificationVariableDeclarations; $fromRoot = \reset($from); $rootAlias = $fromRoot->rangeVariableDeclaration->aliasIdentificationVariable; $rootClass = $queryComponents[$rootAlias]['metadata']; $this->validate($AST); $identifier = $rootClass->getSingleIdentifierFieldName(); if (isset($rootClass->associationMappings[$identifier])) { throw new \RuntimeException('Paginating an entity with foreign key as identifier only works when using the Output Walkers. Call Paginator#setUseOutputWalkers(true) before iterating the paginator.'); } $this->_getQuery()->setHint(self::IDENTIFIER_TYPE, \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($rootClass->fieldMappings[$identifier]['type'])); $this->_getQuery()->setHint(self::FORCE_DBAL_TYPE_CONVERSION, \true); $pathExpression = new \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression(\MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_STATE_FIELD | \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_SINGLE_VALUED_ASSOCIATION, $rootAlias, $identifier); $pathExpression->type = \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_STATE_FIELD; $AST->selectClause->selectExpressions = [new \MailPoetVendor\Doctrine\ORM\Query\AST\SelectExpression($pathExpression, '_dctrn_id')]; $AST->selectClause->isDistinct = \true; if (!isset($AST->orderByClause)) { return; } foreach ($AST->orderByClause->orderByItems as $item) { if ($item->expression instanceof \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression) { $AST->selectClause->selectExpressions[] = new \MailPoetVendor\Doctrine\ORM\Query\AST\SelectExpression($this->createSelectExpressionItem($item->expression), '_dctrn_ord' . $this->_aliasCounter++); continue; } if (\is_string($item->expression) && isset($queryComponents[$item->expression])) { $qComp = $queryComponents[$item->expression]; if (isset($qComp['resultVariable'])) { $AST->selectClause->selectExpressions[] = new \MailPoetVendor\Doctrine\ORM\Query\AST\SelectExpression($qComp['resultVariable'], $item->expression); } } } } private function validate(\MailPoetVendor\Doctrine\ORM\Query\AST\SelectStatement $AST) : void { $queryComponents = $this->getQueryComponents(); $query = $this->_getQuery(); $from = $AST->fromClause->identificationVariableDeclarations; $fromRoot = \reset($from); if ($query instanceof \MailPoetVendor\Doctrine\ORM\Query && $query->getMaxResults() !== null && $AST->orderByClause && \count($fromRoot->joins)) { foreach ($AST->orderByClause->orderByItems as $orderByItem) { $expression = $orderByItem->expression; if ($orderByItem->expression instanceof \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression && isset($queryComponents[$expression->identificationVariable])) { $queryComponent = $queryComponents[$expression->identificationVariable]; if (isset($queryComponent['parent']) && $queryComponent['relation']['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadataInfo::TO_MANY) { throw new \RuntimeException('Cannot select distinct identifiers from query with LIMIT and ORDER BY on a column from a fetch joined to-many association. Use output walkers.'); } } } } } private function createSelectExpressionItem(\MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression $pathExpression) : \MailPoetVendor\Doctrine\ORM\Query\AST\Node { if ($pathExpression->type === \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_SINGLE_VALUED_ASSOCIATION) { $identity = new \MailPoetVendor\Doctrine\ORM\Query\AST\Functions\IdentityFunction('identity'); $identity->pathExpression = clone $pathExpression; return $identity; } return clone $pathExpression; } } 