<?php
 namespace MailPoetVendor\Doctrine\DBAL; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Abstraction\Result; use MailPoetVendor\Doctrine\DBAL\Driver\Exception; use MailPoetVendor\Doctrine\DBAL\Driver\Statement as DriverStatement; use MailPoetVendor\Doctrine\DBAL\Exception\NoKeyValue; use MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform; use MailPoetVendor\Doctrine\DBAL\Result as BaseResult; use MailPoetVendor\Doctrine\DBAL\Types\Type; use MailPoetVendor\Doctrine\Deprecations\Deprecation; use IteratorAggregate; use PDO; use PDOStatement; use Throwable; use Traversable; use function array_shift; use function is_array; use function is_string; class Statement implements \IteratorAggregate, \MailPoetVendor\Doctrine\DBAL\Driver\Statement, \MailPoetVendor\Doctrine\DBAL\Abstraction\Result { protected $sql; protected $params = []; protected $types = []; protected $stmt; protected $platform; protected $conn; public function __construct($sql, \MailPoetVendor\Doctrine\DBAL\Connection $conn) { $this->sql = $sql; $this->stmt = $conn->getWrappedConnection()->prepare($sql); $this->conn = $conn; $this->platform = $conn->getDatabasePlatform(); } public function bindValue($param, $value, $type = \MailPoetVendor\Doctrine\DBAL\ParameterType::STRING) { $this->params[$param] = $value; $this->types[$param] = $type; if ($type !== null) { if (\is_string($type)) { $type = \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($type); } if ($type instanceof \MailPoetVendor\Doctrine\DBAL\Types\Type) { $value = $type->convertToDatabaseValue($value, $this->platform); $bindingType = $type->getBindingType(); } else { $bindingType = $type; } return $this->stmt->bindValue($param, $value, $bindingType); } return $this->stmt->bindValue($param, $value); } public function bindParam($param, &$variable, $type = \MailPoetVendor\Doctrine\DBAL\ParameterType::STRING, $length = null) { $this->params[$param] = $variable; $this->types[$param] = $type; if ($this->stmt instanceof \PDOStatement) { $length = $length ?? 0; } return $this->stmt->bindParam($param, $variable, $type, $length); } public function execute($params = null) { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4580', 'Statement::execute() is deprecated, use Statement::executeQuery() or Statement::executeStatement() instead'); if (\is_array($params)) { $this->params = $params; } $logger = $this->conn->getConfiguration()->getSQLLogger(); if ($logger) { $logger->startQuery($this->sql, $this->params, $this->types); } try { $stmt = $this->stmt->execute($params); } catch (\Throwable $ex) { if ($logger) { $logger->stopQuery(); } $this->conn->handleExceptionDuringQuery($ex, $this->sql, $this->params, $this->types); } if ($logger) { $logger->stopQuery(); } return $stmt; } public function executeQuery(array $params = []) : \MailPoetVendor\Doctrine\DBAL\Result { if ($params === []) { $params = null; } $this->execute($params); return new \MailPoetVendor\Doctrine\DBAL\ForwardCompatibility\Result($this); } public function executeStatement(array $params = []) : int { if ($params === []) { $params = null; } $this->execute($params); return $this->rowCount(); } public function closeCursor() { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4049', 'Statement::closeCursor() is deprecated, use Result::free() instead.'); return $this->stmt->closeCursor(); } public function columnCount() { return $this->stmt->columnCount(); } public function errorCode() { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/3507', 'Connection::errorCode() is deprecated, use getCode() or getSQLState() on Exception instead.'); return $this->stmt->errorCode(); } public function errorInfo() { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/3507', 'Connection::errorInfo() is deprecated, use getCode() or getSQLState() on Exception instead.'); return $this->stmt->errorInfo(); } public function setFetchMode($fetchMode, $arg2 = null, $arg3 = null) { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4019', 'Statement::setFetchMode() is deprecated, use explicit Result::fetch*() APIs instead.'); if ($arg2 === null) { return $this->stmt->setFetchMode($fetchMode); } if ($arg3 === null) { return $this->stmt->setFetchMode($fetchMode, $arg2); } return $this->stmt->setFetchMode($fetchMode, $arg2, $arg3); } public function getIterator() { \MailPoetVendor\Doctrine\Deprecations\Deprecation::trigger('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4019', 'Statement::getIterator() is deprecated, use Result::iterateNumeric(), iterateAssociative() ' . 'or iterateColumn() instead.'); return $this->stmt; } public function fetch($fetchMode = null, $cursorOrientation = \PDO::FETCH_ORI_NEXT, $cursorOffset = 0) { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4019', 'Statement::fetch() is deprecated, use Result::fetchNumeric(), fetchAssociative() or fetchOne() instead.'); return $this->stmt->fetch($fetchMode); } public function fetchAll($fetchMode = null, $fetchArgument = null, $ctorArgs = null) { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4019', 'Statement::fetchAll() is deprecated, use Result::fetchAllNumeric(), fetchAllAssociative() or ' . 'fetchFirstColumn() instead.'); if ($ctorArgs !== null) { return $this->stmt->fetchAll($fetchMode, $fetchArgument, $ctorArgs); } if ($fetchArgument !== null) { return $this->stmt->fetchAll($fetchMode, $fetchArgument); } return $this->stmt->fetchAll($fetchMode); } public function fetchColumn($columnIndex = 0) { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/pull/4019', 'Statement::fetchColumn() is deprecated, use Result::fetchOne() instead.'); return $this->stmt->fetchColumn($columnIndex); } public function fetchNumeric() { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); try { if ($this->stmt instanceof \MailPoetVendor\Doctrine\DBAL\Abstraction\Result) { return $this->stmt->fetchNumeric(); } return $this->stmt->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::NUMERIC); } catch (\MailPoetVendor\Doctrine\DBAL\Driver\Exception $e) { $this->conn->handleDriverException($e); } } public function fetchAssociative() { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); try { if ($this->stmt instanceof \MailPoetVendor\Doctrine\DBAL\Abstraction\Result) { return $this->stmt->fetchAssociative(); } return $this->stmt->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::ASSOCIATIVE); } catch (\MailPoetVendor\Doctrine\DBAL\Driver\Exception $e) { $this->conn->handleDriverException($e); } } public function fetchOne() { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); try { if ($this->stmt instanceof \MailPoetVendor\Doctrine\DBAL\Abstraction\Result) { return $this->stmt->fetchOne(); } return $this->stmt->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::COLUMN); } catch (\MailPoetVendor\Doctrine\DBAL\Driver\Exception $e) { $this->conn->handleDriverException($e); } } public function fetchAllNumeric() : array { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); try { if ($this->stmt instanceof \MailPoetVendor\Doctrine\DBAL\Abstraction\Result) { return $this->stmt->fetchAllNumeric(); } return $this->stmt->fetchAll(\MailPoetVendor\Doctrine\DBAL\FetchMode::NUMERIC); } catch (\MailPoetVendor\Doctrine\DBAL\Driver\Exception $e) { $this->conn->handleDriverException($e); } } public function fetchAllAssociative() : array { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); try { if ($this->stmt instanceof \MailPoetVendor\Doctrine\DBAL\Abstraction\Result) { return $this->stmt->fetchAllAssociative(); } return $this->stmt->fetchAll(\MailPoetVendor\Doctrine\DBAL\FetchMode::ASSOCIATIVE); } catch (\MailPoetVendor\Doctrine\DBAL\Driver\Exception $e) { $this->conn->handleDriverException($e); } } public function fetchAllKeyValue() : array { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); $this->ensureHasKeyValue(); $data = []; foreach ($this->fetchAllNumeric() as [$key, $value]) { $data[$key] = $value; } return $data; } public function fetchAllAssociativeIndexed() : array { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); $data = []; foreach ($this->fetchAll(\MailPoetVendor\Doctrine\DBAL\FetchMode::ASSOCIATIVE) as $row) { $data[\array_shift($row)] = $row; } return $data; } public function fetchFirstColumn() : array { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); try { if ($this->stmt instanceof \MailPoetVendor\Doctrine\DBAL\Abstraction\Result) { return $this->stmt->fetchFirstColumn(); } return $this->stmt->fetchAll(\MailPoetVendor\Doctrine\DBAL\FetchMode::COLUMN); } catch (\MailPoetVendor\Doctrine\DBAL\Driver\Exception $e) { $this->conn->handleDriverException($e); } } public function iterateNumeric() : \Traversable { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); try { if ($this->stmt instanceof \MailPoetVendor\Doctrine\DBAL\Abstraction\Result) { while (($row = $this->stmt->fetchNumeric()) !== \false) { (yield $row); } } else { while (($row = $this->stmt->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::NUMERIC)) !== \false) { (yield $row); } } } catch (\MailPoetVendor\Doctrine\DBAL\Driver\Exception $e) { $this->conn->handleDriverException($e); } } public function iterateAssociative() : \Traversable { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); try { if ($this->stmt instanceof \MailPoetVendor\Doctrine\DBAL\Abstraction\Result) { while (($row = $this->stmt->fetchAssociative()) !== \false) { (yield $row); } } else { while (($row = $this->stmt->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::ASSOCIATIVE)) !== \false) { (yield $row); } } } catch (\MailPoetVendor\Doctrine\DBAL\Driver\Exception $e) { $this->conn->handleDriverException($e); } } public function iterateKeyValue() : \Traversable { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); $this->ensureHasKeyValue(); foreach ($this->iterateNumeric() as [$key, $value]) { (yield $key => $value); } } public function iterateAssociativeIndexed() : \Traversable { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); while (($row = $this->stmt->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::ASSOCIATIVE)) !== \false) { (yield \array_shift($row) => $row); } } public function iterateColumn() : \Traversable { \MailPoetVendor\Doctrine\Deprecations\Deprecation::triggerIfCalledFromOutside('doctrine/dbal', 'https://github.com/doctrine/dbal/issues/4554', 'Statement::%s() is deprecated, use Result::%s() instead.', __FUNCTION__, __FUNCTION__); try { if ($this->stmt instanceof \MailPoetVendor\Doctrine\DBAL\Abstraction\Result) { while (($value = $this->stmt->fetchOne()) !== \false) { (yield $value); } } else { while (($value = $this->stmt->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::COLUMN)) !== \false) { (yield $value); } } } catch (\MailPoetVendor\Doctrine\DBAL\Driver\Exception $e) { $this->conn->handleDriverException($e); } } public function rowCount() { return $this->stmt->rowCount(); } public function free() : void { if ($this->stmt instanceof \MailPoetVendor\Doctrine\DBAL\Abstraction\Result) { $this->stmt->free(); return; } $this->stmt->closeCursor(); } public function getWrappedStatement() { return $this->stmt; } private function ensureHasKeyValue() : void { $columnCount = $this->columnCount(); if ($columnCount < 2) { throw \MailPoetVendor\Doctrine\DBAL\Exception\NoKeyValue::fromColumnCount($columnCount); } } } 