<?php
 namespace MailPoetVendor\Doctrine\DBAL; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Driver\DriverException as DeprecatedDriverException; use MailPoetVendor\Doctrine\DBAL\Driver\ExceptionConverterDriver; use MailPoetVendor\Doctrine\DBAL\Exception\DriverException; use MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform; use MailPoetVendor\Doctrine\DBAL\Types\Type; use Throwable; use function array_map; use function bin2hex; use function get_class; use function gettype; use function implode; use function is_object; use function is_resource; use function is_string; use function json_encode; use function preg_replace; use function spl_object_hash; use function sprintf; class DBALException extends \Exception { public static function notSupported($method) { return new \MailPoetVendor\Doctrine\DBAL\Exception(\sprintf("Operation '%s' is not supported by platform.", $method)); } public static function invalidPlatformSpecified() : self { return new \MailPoetVendor\Doctrine\DBAL\Exception("Invalid 'platform' option specified, need to give an instance of " . \MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform::class . '.'); } public static function invalidPlatformType($invalidPlatform) : self { if (\is_object($invalidPlatform)) { return new \MailPoetVendor\Doctrine\DBAL\Exception(\sprintf("Option 'platform' must be a subtype of '%s', instance of '%s' given", \MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform::class, \get_class($invalidPlatform))); } return new \MailPoetVendor\Doctrine\DBAL\Exception(\sprintf("Option 'platform' must be an object and subtype of '%s'. Got '%s'", \MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform::class, \gettype($invalidPlatform))); } public static function invalidPlatformVersionSpecified($version, $expectedFormat) { return new \MailPoetVendor\Doctrine\DBAL\Exception(\sprintf('Invalid platform version "%s" specified. ' . 'The platform version has to be specified in the format: "%s".', $version, $expectedFormat)); } public static function invalidPdoInstance() { return new \MailPoetVendor\Doctrine\DBAL\Exception("The 'pdo' option was used in DriverManager::getConnection() but no " . 'instance of PDO was given.'); } public static function driverRequired($url = null) { if ($url) { return new \MailPoetVendor\Doctrine\DBAL\Exception(\sprintf("The options 'driver' or 'driverClass' are mandatory if a connection URL without scheme " . 'is given to DriverManager::getConnection(). Given URL: %s', $url)); } return new \MailPoetVendor\Doctrine\DBAL\Exception("The options 'driver' or 'driverClass' are mandatory if no PDO " . 'instance is given to DriverManager::getConnection().'); } public static function unknownDriver($unknownDriverName, array $knownDrivers) { return new \MailPoetVendor\Doctrine\DBAL\Exception("The given 'driver' " . $unknownDriverName . ' is unknown, ' . 'Doctrine currently supports only the following drivers: ' . \implode(', ', $knownDrivers)); } public static function driverExceptionDuringQuery(\MailPoetVendor\Doctrine\DBAL\Driver $driver, \Throwable $driverEx, $sql, array $params = []) { $msg = "An exception occurred while executing '" . $sql . "'"; if ($params) { $msg .= ' with params ' . self::formatParameters($params); } $msg .= ":\n\n" . $driverEx->getMessage(); return static::wrapException($driver, $driverEx, $msg); } public static function driverException(\MailPoetVendor\Doctrine\DBAL\Driver $driver, \Throwable $driverEx) { return static::wrapException($driver, $driverEx, 'An exception occurred in driver: ' . $driverEx->getMessage()); } private static function wrapException(\MailPoetVendor\Doctrine\DBAL\Driver $driver, \Throwable $driverEx, string $msg) { if ($driverEx instanceof \MailPoetVendor\Doctrine\DBAL\Exception\DriverException) { return $driverEx; } if ($driver instanceof \MailPoetVendor\Doctrine\DBAL\Driver\ExceptionConverterDriver && $driverEx instanceof \MailPoetVendor\Doctrine\DBAL\Driver\DriverException) { return $driver->convertException($msg, $driverEx); } return new \MailPoetVendor\Doctrine\DBAL\Exception($msg, 0, $driverEx); } private static function formatParameters(array $params) { return '[' . \implode(', ', \array_map(static function ($param) { if (\is_resource($param)) { return (string) $param; } $json = @\json_encode($param); if (!\is_string($json) || $json === 'null' && \is_string($param)) { return \sprintf('"%s"', \preg_replace('/.{2}/', '\\x$0', \bin2hex($param))); } return $json; }, $params)) . ']'; } public static function invalidWrapperClass($wrapperClass) { return new \MailPoetVendor\Doctrine\DBAL\Exception("The given 'wrapperClass' " . $wrapperClass . ' has to be a ' . 'subtype of \\Doctrine\\DBAL\\Connection.'); } public static function invalidDriverClass($driverClass) { return new \MailPoetVendor\Doctrine\DBAL\Exception("The given 'driverClass' " . $driverClass . ' has to implement the ' . \MailPoetVendor\Doctrine\DBAL\Driver::class . ' interface.'); } public static function invalidTableName($tableName) { return new \MailPoetVendor\Doctrine\DBAL\Exception('Invalid table name specified: ' . $tableName); } public static function noColumnsSpecifiedForTable($tableName) { return new \MailPoetVendor\Doctrine\DBAL\Exception('No columns specified for table ' . $tableName); } public static function limitOffsetInvalid() { return new \MailPoetVendor\Doctrine\DBAL\Exception('Invalid Offset in Limit Query, it has to be larger than or equal to 0.'); } public static function typeExists($name) { return new \MailPoetVendor\Doctrine\DBAL\Exception('Type ' . $name . ' already exists.'); } public static function unknownColumnType($name) { return new \MailPoetVendor\Doctrine\DBAL\Exception('Unknown column type "' . $name . '" requested. Any Doctrine type that you use has ' . 'to be registered with \\Doctrine\\DBAL\\Types\\Type::addType(). You can get a list of all the ' . 'known types with \\Doctrine\\DBAL\\Types\\Type::getTypesMap(). If this error occurs during database ' . 'introspection then you might have forgotten to register all database types for a Doctrine Type. Use ' . 'AbstractPlatform#registerDoctrineTypeMapping() or have your custom types implement ' . 'Type#getMappedDatabaseTypes(). If the type name is empty you might ' . 'have a problem with the cache or forgot some mapping information.'); } public static function typeNotFound($name) { return new \MailPoetVendor\Doctrine\DBAL\Exception('Type to be overwritten ' . $name . ' does not exist.'); } public static function typeNotRegistered(\MailPoetVendor\Doctrine\DBAL\Types\Type $type) : self { return new \MailPoetVendor\Doctrine\DBAL\Exception(\sprintf('Type of the class %s@%s is not registered.', \get_class($type), \spl_object_hash($type))); } public static function typeAlreadyRegistered(\MailPoetVendor\Doctrine\DBAL\Types\Type $type) : self { return new \MailPoetVendor\Doctrine\DBAL\Exception(\sprintf('Type of the class %s@%s is already registered.', \get_class($type), \spl_object_hash($type))); } } 