<?php
 namespace MailPoetVendor\Doctrine\Common\Collections\Expr; if (!defined('ABSPATH')) exit; use ArrayAccess; use Closure; use RuntimeException; use function in_array; use function is_array; use function is_scalar; use function iterator_to_array; use function method_exists; use function preg_match; use function preg_replace_callback; use function strlen; use function strpos; use function strtoupper; use function substr; class ClosureExpressionVisitor extends \MailPoetVendor\Doctrine\Common\Collections\Expr\ExpressionVisitor { public static function getObjectFieldValue($object, $field) { if (\is_array($object)) { return $object[$field]; } $accessors = ['get', 'is']; foreach ($accessors as $accessor) { $accessor .= $field; if (\method_exists($object, $accessor)) { return $object->{$accessor}(); } } if (\preg_match('/^is[A-Z]+/', $field) === 1 && \method_exists($object, $field)) { return $object->{$field}(); } $accessor = $accessors[0] . $field; if (\method_exists($object, '__call')) { return $object->{$accessor}(); } if ($object instanceof \ArrayAccess) { return $object[$field]; } if (isset($object->{$field})) { return $object->{$field}; } $ccField = \preg_replace_callback('/_(.?)/', static function ($matches) { return \strtoupper($matches[1]); }, $field); foreach ($accessors as $accessor) { $accessor .= $ccField; if (\method_exists($object, $accessor)) { return $object->{$accessor}(); } } return $object->{$field}; } public static function sortByField($name, $orientation = 1, ?\Closure $next = null) { if (!$next) { $next = static function () : int { return 0; }; } return static function ($a, $b) use($name, $next, $orientation) : int { $aValue = \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($a, $name); $bValue = \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($b, $name); if ($aValue === $bValue) { return $next($a, $b); } return ($aValue > $bValue ? 1 : -1) * $orientation; }; } public function walkComparison(\MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison $comparison) { $field = $comparison->getField(); $value = $comparison->getValue()->getValue(); switch ($comparison->getOperator()) { case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::EQ: return static function ($object) use($field, $value) : bool { return \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field) === $value; }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::NEQ: return static function ($object) use($field, $value) : bool { return \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field) !== $value; }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::LT: return static function ($object) use($field, $value) : bool { return \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field) < $value; }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::LTE: return static function ($object) use($field, $value) : bool { return \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field) <= $value; }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::GT: return static function ($object) use($field, $value) : bool { return \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field) > $value; }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::GTE: return static function ($object) use($field, $value) : bool { return \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field) >= $value; }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::IN: return static function ($object) use($field, $value) : bool { $fieldValue = \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field); return \in_array($fieldValue, $value, \is_scalar($fieldValue)); }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::NIN: return static function ($object) use($field, $value) : bool { $fieldValue = \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field); return !\in_array($fieldValue, $value, \is_scalar($fieldValue)); }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::CONTAINS: return static function ($object) use($field, $value) { return \strpos(\MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field), $value) !== \false; }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::MEMBER_OF: return static function ($object) use($field, $value) : bool { $fieldValues = \MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field); if (!\is_array($fieldValues)) { $fieldValues = \iterator_to_array($fieldValues); } return \in_array($value, $fieldValues, \true); }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::STARTS_WITH: return static function ($object) use($field, $value) : bool { return \strpos(\MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field), $value) === 0; }; case \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::ENDS_WITH: return static function ($object) use($field, $value) : bool { return $value === \substr(\MailPoetVendor\Doctrine\Common\Collections\Expr\ClosureExpressionVisitor::getObjectFieldValue($object, $field), -\strlen($value)); }; default: throw new \RuntimeException('Unknown comparison operator: ' . $comparison->getOperator()); } } public function walkValue(\MailPoetVendor\Doctrine\Common\Collections\Expr\Value $value) { return $value->getValue(); } public function walkCompositeExpression(\MailPoetVendor\Doctrine\Common\Collections\Expr\CompositeExpression $expr) { $expressionList = []; foreach ($expr->getExpressionList() as $child) { $expressionList[] = $this->dispatch($child); } switch ($expr->getType()) { case \MailPoetVendor\Doctrine\Common\Collections\Expr\CompositeExpression::TYPE_AND: return $this->andExpressions($expressionList); case \MailPoetVendor\Doctrine\Common\Collections\Expr\CompositeExpression::TYPE_OR: return $this->orExpressions($expressionList); default: throw new \RuntimeException('Unknown composite ' . $expr->getType()); } } private function andExpressions(array $expressions) : callable { return static function ($object) use($expressions) : bool { foreach ($expressions as $expression) { if (!$expression($object)) { return \false; } } return \true; }; } private function orExpressions(array $expressions) : callable { return static function ($object) use($expressions) : bool { foreach ($expressions as $expression) { if ($expression($object)) { return \true; } } return \false; }; } } 