<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v8/resources/invoice.proto

namespace Google\Ads\GoogleAds\V8\Resources;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An invoice. All invoice information is snapshotted to match the PDF invoice.
 * For invoices older than the launch of InvoiceService, the snapshotted
 * information may not match the PDF invoice.
 *
 * Generated from protobuf message <code>google.ads.googleads.v8.resources.Invoice</code>
 */
class Invoice extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the invoice. Multiple customers can share a given
     * invoice, so multiple resource names may point to the same invoice.
     * Invoice resource names have the form:
     * `customers/{customer_id}/invoices/{invoice_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $resource_name = '';
    /**
     * Output only. The ID of the invoice. It appears on the invoice PDF as "Invoice number".
     *
     * Generated from protobuf field <code>string id = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $id = null;
    /**
     * Output only. The type of invoice.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v8.enums.InvoiceTypeEnum.InvoiceType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $type = 0;
    /**
     * Output only. The resource name of this invoice’s billing setup.
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     *
     * Generated from protobuf field <code>string billing_setup = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $billing_setup = null;
    /**
     * Output only. A 16 digit ID used to identify the payments account associated with the
     * billing setup, e.g. "1234-5678-9012-3456". It appears on the invoice PDF as
     * "Billing Account Number".
     *
     * Generated from protobuf field <code>string payments_account_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $payments_account_id = null;
    /**
     * Output only. A 12 digit ID used to identify the payments profile associated with the
     * billing setup, e.g. "1234-5678-9012". It appears on the invoice PDF as
     * "Billing ID".
     *
     * Generated from protobuf field <code>string payments_profile_id = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $payments_profile_id = null;
    /**
     * Output only. The issue date in yyyy-mm-dd format. It appears on the invoice PDF as
     * either "Issue date" or "Invoice date".
     *
     * Generated from protobuf field <code>string issue_date = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $issue_date = null;
    /**
     * Output only. The due date in yyyy-mm-dd format.
     *
     * Generated from protobuf field <code>string due_date = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $due_date = null;
    /**
     * Output only. The service period date range of this invoice. The end date is inclusive.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v8.common.DateRange service_date_range = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $service_date_range = null;
    /**
     * Output only. The currency code. All costs are returned in this currency. A subset of the
     * currency codes derived from the ISO 4217 standard is supported.
     *
     * Generated from protobuf field <code>string currency_code = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $currency_code = null;
    /**
     * Output only. The pretax subtotal amount of invoice level adjustments, in micros.
     *
     * Generated from protobuf field <code>int64 adjustments_subtotal_amount_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $adjustments_subtotal_amount_micros = 0;
    /**
     * Output only. The sum of taxes on the invoice level adjustments, in micros.
     *
     * Generated from protobuf field <code>int64 adjustments_tax_amount_micros = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $adjustments_tax_amount_micros = 0;
    /**
     * Output only. The total amount of invoice level adjustments, in micros.
     *
     * Generated from protobuf field <code>int64 adjustments_total_amount_micros = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $adjustments_total_amount_micros = 0;
    /**
     * Output only. The pretax subtotal amount of invoice level regulatory costs, in micros.
     *
     * Generated from protobuf field <code>int64 regulatory_costs_subtotal_amount_micros = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $regulatory_costs_subtotal_amount_micros = 0;
    /**
     * Output only. The sum of taxes on the invoice level regulatory costs, in micros.
     *
     * Generated from protobuf field <code>int64 regulatory_costs_tax_amount_micros = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $regulatory_costs_tax_amount_micros = 0;
    /**
     * Output only. The total amount of invoice level regulatory costs, in micros.
     *
     * Generated from protobuf field <code>int64 regulatory_costs_total_amount_micros = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $regulatory_costs_total_amount_micros = 0;
    /**
     * Output only. The pretax subtotal amount, in micros. This equals the
     * sum of the AccountBudgetSummary subtotal amounts,
     * Invoice.adjustments_subtotal_amount_micros, and
     * Invoice.regulatory_costs_subtotal_amount_micros.
     * Starting with v6, the Invoice.regulatory_costs_subtotal_amount_micros is no
     * longer included.
     *
     * Generated from protobuf field <code>int64 subtotal_amount_micros = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $subtotal_amount_micros = null;
    /**
     * Output only. The sum of all taxes on the invoice, in micros. This equals the sum of the
     * AccountBudgetSummary tax amounts, plus taxes not associated with a specific
     * account budget.
     *
     * Generated from protobuf field <code>int64 tax_amount_micros = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $tax_amount_micros = null;
    /**
     * Output only. The total amount, in micros. This equals the sum of
     * Invoice.subtotal_amount_micros and Invoice.tax_amount_micros.
     * Starting with v6, Invoice.regulatory_costs_subtotal_amount_micros is
     * also added as it is no longer already included in
     * Invoice.tax_amount_micros.
     *
     * Generated from protobuf field <code>int64 total_amount_micros = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $total_amount_micros = null;
    /**
     * Output only. The resource name of the original invoice corrected, wrote off, or canceled
     * by this invoice, if applicable. If `corrected_invoice` is set,
     * `replaced_invoices` will not be set.
     * Invoice resource names have the form:
     * `customers/{customer_id}/invoices/{invoice_id}`
     *
     * Generated from protobuf field <code>string corrected_invoice = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $corrected_invoice = null;
    /**
     * Output only. The resource name of the original invoice(s) being rebilled or replaced by
     * this invoice, if applicable. There might be multiple replaced invoices due
     * to invoice consolidation. The replaced invoices may not belong to the same
     * payments account. If `replaced_invoices` is set, `corrected_invoice` will
     * not be set.
     * Invoice resource names have the form:
     * `customers/{customer_id}/invoices/{invoice_id}`
     *
     * Generated from protobuf field <code>repeated string replaced_invoices = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $replaced_invoices;
    /**
     * Output only. The URL to a PDF copy of the invoice. Users need to pass in their OAuth
     * token to request the PDF with this URL.
     *
     * Generated from protobuf field <code>string pdf_url = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $pdf_url = null;
    /**
     * Output only. The list of summarized account budget information associated with this
     * invoice.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v8.resources.Invoice.AccountBudgetSummary account_budget_summaries = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $account_budget_summaries;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $resource_name
     *           Output only. The resource name of the invoice. Multiple customers can share a given
     *           invoice, so multiple resource names may point to the same invoice.
     *           Invoice resource names have the form:
     *           `customers/{customer_id}/invoices/{invoice_id}`
     *     @type string $id
     *           Output only. The ID of the invoice. It appears on the invoice PDF as "Invoice number".
     *     @type int $type
     *           Output only. The type of invoice.
     *     @type string $billing_setup
     *           Output only. The resource name of this invoice’s billing setup.
     *           `customers/{customer_id}/billingSetups/{billing_setup_id}`
     *     @type string $payments_account_id
     *           Output only. A 16 digit ID used to identify the payments account associated with the
     *           billing setup, e.g. "1234-5678-9012-3456". It appears on the invoice PDF as
     *           "Billing Account Number".
     *     @type string $payments_profile_id
     *           Output only. A 12 digit ID used to identify the payments profile associated with the
     *           billing setup, e.g. "1234-5678-9012". It appears on the invoice PDF as
     *           "Billing ID".
     *     @type string $issue_date
     *           Output only. The issue date in yyyy-mm-dd format. It appears on the invoice PDF as
     *           either "Issue date" or "Invoice date".
     *     @type string $due_date
     *           Output only. The due date in yyyy-mm-dd format.
     *     @type \Google\Ads\GoogleAds\V8\Common\DateRange $service_date_range
     *           Output only. The service period date range of this invoice. The end date is inclusive.
     *     @type string $currency_code
     *           Output only. The currency code. All costs are returned in this currency. A subset of the
     *           currency codes derived from the ISO 4217 standard is supported.
     *     @type int|string $adjustments_subtotal_amount_micros
     *           Output only. The pretax subtotal amount of invoice level adjustments, in micros.
     *     @type int|string $adjustments_tax_amount_micros
     *           Output only. The sum of taxes on the invoice level adjustments, in micros.
     *     @type int|string $adjustments_total_amount_micros
     *           Output only. The total amount of invoice level adjustments, in micros.
     *     @type int|string $regulatory_costs_subtotal_amount_micros
     *           Output only. The pretax subtotal amount of invoice level regulatory costs, in micros.
     *     @type int|string $regulatory_costs_tax_amount_micros
     *           Output only. The sum of taxes on the invoice level regulatory costs, in micros.
     *     @type int|string $regulatory_costs_total_amount_micros
     *           Output only. The total amount of invoice level regulatory costs, in micros.
     *     @type int|string $subtotal_amount_micros
     *           Output only. The pretax subtotal amount, in micros. This equals the
     *           sum of the AccountBudgetSummary subtotal amounts,
     *           Invoice.adjustments_subtotal_amount_micros, and
     *           Invoice.regulatory_costs_subtotal_amount_micros.
     *           Starting with v6, the Invoice.regulatory_costs_subtotal_amount_micros is no
     *           longer included.
     *     @type int|string $tax_amount_micros
     *           Output only. The sum of all taxes on the invoice, in micros. This equals the sum of the
     *           AccountBudgetSummary tax amounts, plus taxes not associated with a specific
     *           account budget.
     *     @type int|string $total_amount_micros
     *           Output only. The total amount, in micros. This equals the sum of
     *           Invoice.subtotal_amount_micros and Invoice.tax_amount_micros.
     *           Starting with v6, Invoice.regulatory_costs_subtotal_amount_micros is
     *           also added as it is no longer already included in
     *           Invoice.tax_amount_micros.
     *     @type string $corrected_invoice
     *           Output only. The resource name of the original invoice corrected, wrote off, or canceled
     *           by this invoice, if applicable. If `corrected_invoice` is set,
     *           `replaced_invoices` will not be set.
     *           Invoice resource names have the form:
     *           `customers/{customer_id}/invoices/{invoice_id}`
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $replaced_invoices
     *           Output only. The resource name of the original invoice(s) being rebilled or replaced by
     *           this invoice, if applicable. There might be multiple replaced invoices due
     *           to invoice consolidation. The replaced invoices may not belong to the same
     *           payments account. If `replaced_invoices` is set, `corrected_invoice` will
     *           not be set.
     *           Invoice resource names have the form:
     *           `customers/{customer_id}/invoices/{invoice_id}`
     *     @type string $pdf_url
     *           Output only. The URL to a PDF copy of the invoice. Users need to pass in their OAuth
     *           token to request the PDF with this URL.
     *     @type \Google\Ads\GoogleAds\V8\Resources\Invoice\AccountBudgetSummary[]|\Google\Protobuf\Internal\RepeatedField $account_budget_summaries
     *           Output only. The list of summarized account budget information associated with this
     *           invoice.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V8\Resources\Invoice::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the invoice. Multiple customers can share a given
     * invoice, so multiple resource names may point to the same invoice.
     * Invoice resource names have the form:
     * `customers/{customer_id}/invoices/{invoice_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * Output only. The resource name of the invoice. Multiple customers can share a given
     * invoice, so multiple resource names may point to the same invoice.
     * Invoice resource names have the form:
     * `customers/{customer_id}/invoices/{invoice_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * Output only. The ID of the invoice. It appears on the invoice PDF as "Invoice number".
     *
     * Generated from protobuf field <code>string id = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : '';
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * Output only. The ID of the invoice. It appears on the invoice PDF as "Invoice number".
     *
     * Generated from protobuf field <code>string id = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Output only. The type of invoice.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v8.enums.InvoiceTypeEnum.InvoiceType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Output only. The type of invoice.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v8.enums.InvoiceTypeEnum.InvoiceType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V8\Enums\InvoiceTypeEnum\InvoiceType::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Output only. The resource name of this invoice’s billing setup.
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     *
     * Generated from protobuf field <code>string billing_setup = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getBillingSetup()
    {
        return isset($this->billing_setup) ? $this->billing_setup : '';
    }

    public function hasBillingSetup()
    {
        return isset($this->billing_setup);
    }

    public function clearBillingSetup()
    {
        unset($this->billing_setup);
    }

    /**
     * Output only. The resource name of this invoice’s billing setup.
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     *
     * Generated from protobuf field <code>string billing_setup = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setBillingSetup($var)
    {
        GPBUtil::checkString($var, True);
        $this->billing_setup = $var;

        return $this;
    }

    /**
     * Output only. A 16 digit ID used to identify the payments account associated with the
     * billing setup, e.g. "1234-5678-9012-3456". It appears on the invoice PDF as
     * "Billing Account Number".
     *
     * Generated from protobuf field <code>string payments_account_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPaymentsAccountId()
    {
        return isset($this->payments_account_id) ? $this->payments_account_id : '';
    }

    public function hasPaymentsAccountId()
    {
        return isset($this->payments_account_id);
    }

    public function clearPaymentsAccountId()
    {
        unset($this->payments_account_id);
    }

    /**
     * Output only. A 16 digit ID used to identify the payments account associated with the
     * billing setup, e.g. "1234-5678-9012-3456". It appears on the invoice PDF as
     * "Billing Account Number".
     *
     * Generated from protobuf field <code>string payments_account_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPaymentsAccountId($var)
    {
        GPBUtil::checkString($var, True);
        $this->payments_account_id = $var;

        return $this;
    }

    /**
     * Output only. A 12 digit ID used to identify the payments profile associated with the
     * billing setup, e.g. "1234-5678-9012". It appears on the invoice PDF as
     * "Billing ID".
     *
     * Generated from protobuf field <code>string payments_profile_id = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPaymentsProfileId()
    {
        return isset($this->payments_profile_id) ? $this->payments_profile_id : '';
    }

    public function hasPaymentsProfileId()
    {
        return isset($this->payments_profile_id);
    }

    public function clearPaymentsProfileId()
    {
        unset($this->payments_profile_id);
    }

    /**
     * Output only. A 12 digit ID used to identify the payments profile associated with the
     * billing setup, e.g. "1234-5678-9012". It appears on the invoice PDF as
     * "Billing ID".
     *
     * Generated from protobuf field <code>string payments_profile_id = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPaymentsProfileId($var)
    {
        GPBUtil::checkString($var, True);
        $this->payments_profile_id = $var;

        return $this;
    }

    /**
     * Output only. The issue date in yyyy-mm-dd format. It appears on the invoice PDF as
     * either "Issue date" or "Invoice date".
     *
     * Generated from protobuf field <code>string issue_date = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getIssueDate()
    {
        return isset($this->issue_date) ? $this->issue_date : '';
    }

    public function hasIssueDate()
    {
        return isset($this->issue_date);
    }

    public function clearIssueDate()
    {
        unset($this->issue_date);
    }

    /**
     * Output only. The issue date in yyyy-mm-dd format. It appears on the invoice PDF as
     * either "Issue date" or "Invoice date".
     *
     * Generated from protobuf field <code>string issue_date = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setIssueDate($var)
    {
        GPBUtil::checkString($var, True);
        $this->issue_date = $var;

        return $this;
    }

    /**
     * Output only. The due date in yyyy-mm-dd format.
     *
     * Generated from protobuf field <code>string due_date = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDueDate()
    {
        return isset($this->due_date) ? $this->due_date : '';
    }

    public function hasDueDate()
    {
        return isset($this->due_date);
    }

    public function clearDueDate()
    {
        unset($this->due_date);
    }

    /**
     * Output only. The due date in yyyy-mm-dd format.
     *
     * Generated from protobuf field <code>string due_date = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDueDate($var)
    {
        GPBUtil::checkString($var, True);
        $this->due_date = $var;

        return $this;
    }

    /**
     * Output only. The service period date range of this invoice. The end date is inclusive.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v8.common.DateRange service_date_range = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Ads\GoogleAds\V8\Common\DateRange|null
     */
    public function getServiceDateRange()
    {
        return isset($this->service_date_range) ? $this->service_date_range : null;
    }

    public function hasServiceDateRange()
    {
        return isset($this->service_date_range);
    }

    public function clearServiceDateRange()
    {
        unset($this->service_date_range);
    }

    /**
     * Output only. The service period date range of this invoice. The end date is inclusive.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v8.common.DateRange service_date_range = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Ads\GoogleAds\V8\Common\DateRange $var
     * @return $this
     */
    public function setServiceDateRange($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V8\Common\DateRange::class);
        $this->service_date_range = $var;

        return $this;
    }

    /**
     * Output only. The currency code. All costs are returned in this currency. A subset of the
     * currency codes derived from the ISO 4217 standard is supported.
     *
     * Generated from protobuf field <code>string currency_code = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCurrencyCode()
    {
        return isset($this->currency_code) ? $this->currency_code : '';
    }

    public function hasCurrencyCode()
    {
        return isset($this->currency_code);
    }

    public function clearCurrencyCode()
    {
        unset($this->currency_code);
    }

    /**
     * Output only. The currency code. All costs are returned in this currency. A subset of the
     * currency codes derived from the ISO 4217 standard is supported.
     *
     * Generated from protobuf field <code>string currency_code = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCurrencyCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->currency_code = $var;

        return $this;
    }

    /**
     * Output only. The pretax subtotal amount of invoice level adjustments, in micros.
     *
     * Generated from protobuf field <code>int64 adjustments_subtotal_amount_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getAdjustmentsSubtotalAmountMicros()
    {
        return $this->adjustments_subtotal_amount_micros;
    }

    /**
     * Output only. The pretax subtotal amount of invoice level adjustments, in micros.
     *
     * Generated from protobuf field <code>int64 adjustments_subtotal_amount_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setAdjustmentsSubtotalAmountMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->adjustments_subtotal_amount_micros = $var;

        return $this;
    }

    /**
     * Output only. The sum of taxes on the invoice level adjustments, in micros.
     *
     * Generated from protobuf field <code>int64 adjustments_tax_amount_micros = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getAdjustmentsTaxAmountMicros()
    {
        return $this->adjustments_tax_amount_micros;
    }

    /**
     * Output only. The sum of taxes on the invoice level adjustments, in micros.
     *
     * Generated from protobuf field <code>int64 adjustments_tax_amount_micros = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setAdjustmentsTaxAmountMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->adjustments_tax_amount_micros = $var;

        return $this;
    }

    /**
     * Output only. The total amount of invoice level adjustments, in micros.
     *
     * Generated from protobuf field <code>int64 adjustments_total_amount_micros = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getAdjustmentsTotalAmountMicros()
    {
        return $this->adjustments_total_amount_micros;
    }

    /**
     * Output only. The total amount of invoice level adjustments, in micros.
     *
     * Generated from protobuf field <code>int64 adjustments_total_amount_micros = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setAdjustmentsTotalAmountMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->adjustments_total_amount_micros = $var;

        return $this;
    }

    /**
     * Output only. The pretax subtotal amount of invoice level regulatory costs, in micros.
     *
     * Generated from protobuf field <code>int64 regulatory_costs_subtotal_amount_micros = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getRegulatoryCostsSubtotalAmountMicros()
    {
        return $this->regulatory_costs_subtotal_amount_micros;
    }

    /**
     * Output only. The pretax subtotal amount of invoice level regulatory costs, in micros.
     *
     * Generated from protobuf field <code>int64 regulatory_costs_subtotal_amount_micros = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setRegulatoryCostsSubtotalAmountMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->regulatory_costs_subtotal_amount_micros = $var;

        return $this;
    }

    /**
     * Output only. The sum of taxes on the invoice level regulatory costs, in micros.
     *
     * Generated from protobuf field <code>int64 regulatory_costs_tax_amount_micros = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getRegulatoryCostsTaxAmountMicros()
    {
        return $this->regulatory_costs_tax_amount_micros;
    }

    /**
     * Output only. The sum of taxes on the invoice level regulatory costs, in micros.
     *
     * Generated from protobuf field <code>int64 regulatory_costs_tax_amount_micros = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setRegulatoryCostsTaxAmountMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->regulatory_costs_tax_amount_micros = $var;

        return $this;
    }

    /**
     * Output only. The total amount of invoice level regulatory costs, in micros.
     *
     * Generated from protobuf field <code>int64 regulatory_costs_total_amount_micros = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getRegulatoryCostsTotalAmountMicros()
    {
        return $this->regulatory_costs_total_amount_micros;
    }

    /**
     * Output only. The total amount of invoice level regulatory costs, in micros.
     *
     * Generated from protobuf field <code>int64 regulatory_costs_total_amount_micros = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setRegulatoryCostsTotalAmountMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->regulatory_costs_total_amount_micros = $var;

        return $this;
    }

    /**
     * Output only. The pretax subtotal amount, in micros. This equals the
     * sum of the AccountBudgetSummary subtotal amounts,
     * Invoice.adjustments_subtotal_amount_micros, and
     * Invoice.regulatory_costs_subtotal_amount_micros.
     * Starting with v6, the Invoice.regulatory_costs_subtotal_amount_micros is no
     * longer included.
     *
     * Generated from protobuf field <code>int64 subtotal_amount_micros = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getSubtotalAmountMicros()
    {
        return isset($this->subtotal_amount_micros) ? $this->subtotal_amount_micros : 0;
    }

    public function hasSubtotalAmountMicros()
    {
        return isset($this->subtotal_amount_micros);
    }

    public function clearSubtotalAmountMicros()
    {
        unset($this->subtotal_amount_micros);
    }

    /**
     * Output only. The pretax subtotal amount, in micros. This equals the
     * sum of the AccountBudgetSummary subtotal amounts,
     * Invoice.adjustments_subtotal_amount_micros, and
     * Invoice.regulatory_costs_subtotal_amount_micros.
     * Starting with v6, the Invoice.regulatory_costs_subtotal_amount_micros is no
     * longer included.
     *
     * Generated from protobuf field <code>int64 subtotal_amount_micros = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setSubtotalAmountMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->subtotal_amount_micros = $var;

        return $this;
    }

    /**
     * Output only. The sum of all taxes on the invoice, in micros. This equals the sum of the
     * AccountBudgetSummary tax amounts, plus taxes not associated with a specific
     * account budget.
     *
     * Generated from protobuf field <code>int64 tax_amount_micros = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getTaxAmountMicros()
    {
        return isset($this->tax_amount_micros) ? $this->tax_amount_micros : 0;
    }

    public function hasTaxAmountMicros()
    {
        return isset($this->tax_amount_micros);
    }

    public function clearTaxAmountMicros()
    {
        unset($this->tax_amount_micros);
    }

    /**
     * Output only. The sum of all taxes on the invoice, in micros. This equals the sum of the
     * AccountBudgetSummary tax amounts, plus taxes not associated with a specific
     * account budget.
     *
     * Generated from protobuf field <code>int64 tax_amount_micros = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setTaxAmountMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->tax_amount_micros = $var;

        return $this;
    }

    /**
     * Output only. The total amount, in micros. This equals the sum of
     * Invoice.subtotal_amount_micros and Invoice.tax_amount_micros.
     * Starting with v6, Invoice.regulatory_costs_subtotal_amount_micros is
     * also added as it is no longer already included in
     * Invoice.tax_amount_micros.
     *
     * Generated from protobuf field <code>int64 total_amount_micros = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getTotalAmountMicros()
    {
        return isset($this->total_amount_micros) ? $this->total_amount_micros : 0;
    }

    public function hasTotalAmountMicros()
    {
        return isset($this->total_amount_micros);
    }

    public function clearTotalAmountMicros()
    {
        unset($this->total_amount_micros);
    }

    /**
     * Output only. The total amount, in micros. This equals the sum of
     * Invoice.subtotal_amount_micros and Invoice.tax_amount_micros.
     * Starting with v6, Invoice.regulatory_costs_subtotal_amount_micros is
     * also added as it is no longer already included in
     * Invoice.tax_amount_micros.
     *
     * Generated from protobuf field <code>int64 total_amount_micros = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setTotalAmountMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->total_amount_micros = $var;

        return $this;
    }

    /**
     * Output only. The resource name of the original invoice corrected, wrote off, or canceled
     * by this invoice, if applicable. If `corrected_invoice` is set,
     * `replaced_invoices` will not be set.
     * Invoice resource names have the form:
     * `customers/{customer_id}/invoices/{invoice_id}`
     *
     * Generated from protobuf field <code>string corrected_invoice = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCorrectedInvoice()
    {
        return isset($this->corrected_invoice) ? $this->corrected_invoice : '';
    }

    public function hasCorrectedInvoice()
    {
        return isset($this->corrected_invoice);
    }

    public function clearCorrectedInvoice()
    {
        unset($this->corrected_invoice);
    }

    /**
     * Output only. The resource name of the original invoice corrected, wrote off, or canceled
     * by this invoice, if applicable. If `corrected_invoice` is set,
     * `replaced_invoices` will not be set.
     * Invoice resource names have the form:
     * `customers/{customer_id}/invoices/{invoice_id}`
     *
     * Generated from protobuf field <code>string corrected_invoice = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCorrectedInvoice($var)
    {
        GPBUtil::checkString($var, True);
        $this->corrected_invoice = $var;

        return $this;
    }

    /**
     * Output only. The resource name of the original invoice(s) being rebilled or replaced by
     * this invoice, if applicable. There might be multiple replaced invoices due
     * to invoice consolidation. The replaced invoices may not belong to the same
     * payments account. If `replaced_invoices` is set, `corrected_invoice` will
     * not be set.
     * Invoice resource names have the form:
     * `customers/{customer_id}/invoices/{invoice_id}`
     *
     * Generated from protobuf field <code>repeated string replaced_invoices = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReplacedInvoices()
    {
        return $this->replaced_invoices;
    }

    /**
     * Output only. The resource name of the original invoice(s) being rebilled or replaced by
     * this invoice, if applicable. There might be multiple replaced invoices due
     * to invoice consolidation. The replaced invoices may not belong to the same
     * payments account. If `replaced_invoices` is set, `corrected_invoice` will
     * not be set.
     * Invoice resource names have the form:
     * `customers/{customer_id}/invoices/{invoice_id}`
     *
     * Generated from protobuf field <code>repeated string replaced_invoices = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReplacedInvoices($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->replaced_invoices = $arr;

        return $this;
    }

    /**
     * Output only. The URL to a PDF copy of the invoice. Users need to pass in their OAuth
     * token to request the PDF with this URL.
     *
     * Generated from protobuf field <code>string pdf_url = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPdfUrl()
    {
        return isset($this->pdf_url) ? $this->pdf_url : '';
    }

    public function hasPdfUrl()
    {
        return isset($this->pdf_url);
    }

    public function clearPdfUrl()
    {
        unset($this->pdf_url);
    }

    /**
     * Output only. The URL to a PDF copy of the invoice. Users need to pass in their OAuth
     * token to request the PDF with this URL.
     *
     * Generated from protobuf field <code>string pdf_url = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPdfUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->pdf_url = $var;

        return $this;
    }

    /**
     * Output only. The list of summarized account budget information associated with this
     * invoice.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v8.resources.Invoice.AccountBudgetSummary account_budget_summaries = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAccountBudgetSummaries()
    {
        return $this->account_budget_summaries;
    }

    /**
     * Output only. The list of summarized account budget information associated with this
     * invoice.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v8.resources.Invoice.AccountBudgetSummary account_budget_summaries = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Ads\GoogleAds\V8\Resources\Invoice\AccountBudgetSummary[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAccountBudgetSummaries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\GoogleAds\V8\Resources\Invoice\AccountBudgetSummary::class);
        $this->account_budget_summaries = $arr;

        return $this;
    }

}

