<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v8/resources/campaign.proto

namespace Google\Ads\GoogleAds\V8\Resources\Campaign;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The setting for Shopping campaigns. Defines the universe of products that
 * can be advertised by the campaign, and how this campaign interacts with
 * other Shopping campaigns.
 *
 * Generated from protobuf message <code>google.ads.googleads.v8.resources.Campaign.ShoppingSetting</code>
 */
class ShoppingSetting extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. ID of the Merchant Center account.
     * This field is required for create operations. This field is immutable for
     * Shopping campaigns.
     *
     * Generated from protobuf field <code>int64 merchant_id = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $merchant_id = null;
    /**
     * Immutable. Sales country of products to include in the campaign.
     * This field is required for Shopping campaigns. This field is immutable.
     * This field is optional for non-Shopping campaigns, but it must be equal
     * to 'ZZ' if set.
     *
     * Generated from protobuf field <code>string sales_country = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $sales_country = null;
    /**
     * Priority of the campaign. Campaigns with numerically higher priorities
     * take precedence over those with lower priorities.
     * This field is required for Shopping campaigns, with values between 0 and
     * 2, inclusive.
     * This field is optional for Smart Shopping campaigns, but must be equal to
     * 3 if set.
     *
     * Generated from protobuf field <code>int32 campaign_priority = 7;</code>
     */
    protected $campaign_priority = null;
    /**
     * Whether to include local products.
     *
     * Generated from protobuf field <code>bool enable_local = 8;</code>
     */
    protected $enable_local = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $merchant_id
     *           Immutable. ID of the Merchant Center account.
     *           This field is required for create operations. This field is immutable for
     *           Shopping campaigns.
     *     @type string $sales_country
     *           Immutable. Sales country of products to include in the campaign.
     *           This field is required for Shopping campaigns. This field is immutable.
     *           This field is optional for non-Shopping campaigns, but it must be equal
     *           to 'ZZ' if set.
     *     @type int $campaign_priority
     *           Priority of the campaign. Campaigns with numerically higher priorities
     *           take precedence over those with lower priorities.
     *           This field is required for Shopping campaigns, with values between 0 and
     *           2, inclusive.
     *           This field is optional for Smart Shopping campaigns, but must be equal to
     *           3 if set.
     *     @type bool $enable_local
     *           Whether to include local products.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V8\Resources\Campaign::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. ID of the Merchant Center account.
     * This field is required for create operations. This field is immutable for
     * Shopping campaigns.
     *
     * Generated from protobuf field <code>int64 merchant_id = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int|string
     */
    public function getMerchantId()
    {
        return isset($this->merchant_id) ? $this->merchant_id : 0;
    }

    public function hasMerchantId()
    {
        return isset($this->merchant_id);
    }

    public function clearMerchantId()
    {
        unset($this->merchant_id);
    }

    /**
     * Immutable. ID of the Merchant Center account.
     * This field is required for create operations. This field is immutable for
     * Shopping campaigns.
     *
     * Generated from protobuf field <code>int64 merchant_id = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int|string $var
     * @return $this
     */
    public function setMerchantId($var)
    {
        GPBUtil::checkInt64($var);
        $this->merchant_id = $var;

        return $this;
    }

    /**
     * Immutable. Sales country of products to include in the campaign.
     * This field is required for Shopping campaigns. This field is immutable.
     * This field is optional for non-Shopping campaigns, but it must be equal
     * to 'ZZ' if set.
     *
     * Generated from protobuf field <code>string sales_country = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getSalesCountry()
    {
        return isset($this->sales_country) ? $this->sales_country : '';
    }

    public function hasSalesCountry()
    {
        return isset($this->sales_country);
    }

    public function clearSalesCountry()
    {
        unset($this->sales_country);
    }

    /**
     * Immutable. Sales country of products to include in the campaign.
     * This field is required for Shopping campaigns. This field is immutable.
     * This field is optional for non-Shopping campaigns, but it must be equal
     * to 'ZZ' if set.
     *
     * Generated from protobuf field <code>string sales_country = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setSalesCountry($var)
    {
        GPBUtil::checkString($var, True);
        $this->sales_country = $var;

        return $this;
    }

    /**
     * Priority of the campaign. Campaigns with numerically higher priorities
     * take precedence over those with lower priorities.
     * This field is required for Shopping campaigns, with values between 0 and
     * 2, inclusive.
     * This field is optional for Smart Shopping campaigns, but must be equal to
     * 3 if set.
     *
     * Generated from protobuf field <code>int32 campaign_priority = 7;</code>
     * @return int
     */
    public function getCampaignPriority()
    {
        return isset($this->campaign_priority) ? $this->campaign_priority : 0;
    }

    public function hasCampaignPriority()
    {
        return isset($this->campaign_priority);
    }

    public function clearCampaignPriority()
    {
        unset($this->campaign_priority);
    }

    /**
     * Priority of the campaign. Campaigns with numerically higher priorities
     * take precedence over those with lower priorities.
     * This field is required for Shopping campaigns, with values between 0 and
     * 2, inclusive.
     * This field is optional for Smart Shopping campaigns, but must be equal to
     * 3 if set.
     *
     * Generated from protobuf field <code>int32 campaign_priority = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setCampaignPriority($var)
    {
        GPBUtil::checkInt32($var);
        $this->campaign_priority = $var;

        return $this;
    }

    /**
     * Whether to include local products.
     *
     * Generated from protobuf field <code>bool enable_local = 8;</code>
     * @return bool
     */
    public function getEnableLocal()
    {
        return isset($this->enable_local) ? $this->enable_local : false;
    }

    public function hasEnableLocal()
    {
        return isset($this->enable_local);
    }

    public function clearEnableLocal()
    {
        unset($this->enable_local);
    }

    /**
     * Whether to include local products.
     *
     * Generated from protobuf field <code>bool enable_local = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableLocal($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_local = $var;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ShoppingSetting::class, \Google\Ads\GoogleAds\V8\Resources\Campaign_ShoppingSetting::class);

