<?php
add_action( 'widgets_init', function () {
	register_widget( 'Inspiry_Tours_Search_widget' );
} );

if ( ! class_exists( 'Inspiry_Tours_Search_widget' ) ) {
	class Inspiry_Tours_Search_widget extends WP_Widget {

		/**
		 * Sets up the widgets name etc
		 */
		public function __construct() {
			$widget_ops = array(
				'classname'   => 'inspiry_tours_search_widget',
				'description' => esc_html__( 'Display tours search form.', 'easy-tours' ),
			);

			parent::__construct( 'inspiry_tours_search_widget', esc_html__( 'Inspiry - Tours Search', 'easy-tours' ), $widget_ops );
		}

		/**
		 * Outputs the content of the widget
		 *
		 * @param array $args
		 * @param array $instance
		 */
		public function widget( $args, $instance ) {
			// outputs the content of the widget
			echo wp_kses( $args['before_widget'], inspiry_widget_wrap_allowed_tags() );

			if ( ! empty( $instance['title'] ) ) {
				echo wp_kses(
					$args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'],
					inspiry_widget_heading_allowed_tags()
				);
			}

			?>
			<div>
				<?php

					$search_page_id = get_theme_mod( 'inspiry_search_page', 0 );

					if ( 0 != $search_page_id ) {

						$search_page_url = get_the_permalink( $search_page_id );

						?>
						<form id="tours-search" action="<?php echo esc_url( $search_page_url ); ?>" class="clearfix">

							<p class="form-field tour-destination">
								<?php include get_theme_file_path( '/img/svg/pin.svg' ); ?>
								<select name="destination" id="tour-destination">
									<option value=""><?php esc_html_e( 'Destination (Any)', 'easy-tours' ); ?></option>
									<?php inspiry_taxonomy_options( 'tour-destination', 'destination' ); ?>
								</select>
							</p>

							<p class="form-field tour-type">
								<?php include get_theme_file_path( '/img/svg/type-list.svg' ); ?>
								<select name="type" id="tour-type">
									<option value=""><?php esc_html_e( 'Tour Type (Any)', 'easy-tours' ); ?></option>
									<?php inspiry_taxonomy_options( 'tour-type', 'type' ); ?>
								</select>
							</p>

							<p class="form-field tour-month">
								<?php include get_theme_file_path( '/img/svg/calender.svg' ); ?>
								<select name="month" id="tour-month">
									<option value=""><?php esc_html_e( 'Tour Month (Any)', 'easy-tours' ); ?></option>
									<?php inspiry_taxonomy_options( 'tour-month', 'month' ); ?>
								</select>
							</p>

							<p class="form-field max-price">
								<input type="text" name="max_price" value="<?php echo ( isset( $_GET['max_price'] ) ) ? esc_attr( $_GET['max_price'] ) : ''; ?>" placeholder="<?php esc_html_e( 'Maximum Price', 'easy-tours' ); ?>">
							</p>

							<input type="submit" value="<?php esc_html_e( 'Search', 'easy-tours' ); ?>">

						</form>
						<?php
					}
				?>
			</div>
			<?php

			echo wp_kses( $args['after_widget'], inspiry_widget_wrap_allowed_tags() );
		}


		/**
		 * Outputs the options form on admin
		 *
		 * @param array $instance The widget options
		 *
		 * @return void
		 */
		public function form( $instance ) {
			// outputs the options form on admin
			$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'Find Tours', 'easy-tours' );
			?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'easy-tours' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_html( $title ); ?>">
			</p>
			<?php
		}

		/**
		 * Processing widget options on save
		 *
		 * @param array $new_instance The new options
		 * @param array $old_instance The previous options
		 *
		 * @return array
		 */
		public function update( $new_instance, $old_instance ) {

			$updated_instance = array();

			// processes widget options to be saved
			foreach ( $new_instance as $key => $value ) {
				$updated_instance[ $key ] = sanitize_text_field( $value );
			}

			return $updated_instance;
		}
	}
}
