<?php

/**
 * The class responsible for providing tours custom post type and related stuff.
 */
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-et-tour-post-type.php';

/**
 * The class responsible for providing tours custom post type and related stuff.
 */
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-easy-tours-settings.php';

/**
 * Tour Post Type
 */
$tours_post_type = new ET_Tour_Post_Type();
add_action( 'init', array( $tours_post_type, 'register_tour_post_type' ) );
add_action( 'enter_title_here', array( $tours_post_type, 'change_title_text' ) );
add_filter( 'init', array( $tours_post_type, 'register_destination_taxonomy' ) );
add_filter( 'init', array( $tours_post_type, 'register_type_taxonomy' ) );
add_filter( 'init', array( $tours_post_type, 'register_month_taxonomy' ) );
add_filter( 'rwmb_meta_boxes', array( $tours_post_type, 'register_meta_boxes' ) );
add_filter( 'rwmb_meta_boxes', array( $tours_post_type, 'register_taxonomy_meta_boxes' ) );
add_filter( 'manage_tour_posts_columns', array( $tours_post_type, 'update_columns' ) );
add_filter( 'manage_tour_posts_custom_column', array( $tours_post_type, 'manage_columns_contents' ), 10, 2 );

/**
 * Easy Tours Settings
 */
$easy_tours_settings = new Easy_Tours_Settings();
add_action( 'admin_menu', array( $easy_tours_settings, 'easy_tours_settings_menu' ) );
add_action( 'admin_init', array( $easy_tours_settings, 'initialize_url_slugs_options' ) );
add_action( 'admin_init', array( $easy_tours_settings, 'initialize_price_format_options' ) );
add_action( 'admin_init', array( $easy_tours_settings, 'initialize_others_options' ) );
add_action( 'plugin_action_links_easy-tours/easy-tours.php', array( $easy_tours_settings, 'easy_tours_action_links' ) );

/**
 * Widgets registration
 */
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/widgets/inspiry-tours.php';
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/widgets/inspiry-tours-search.php';
require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/widgets/inspiry-top-rated-tours.php';

/**
 * Meta Boxes Stuff
 */
// Deactivate Meta Box Plugin and related extensions if Installed
add_action( 'init', function () {

	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

	// Meta Box Plugin
	if ( is_plugin_active( 'meta-box/meta-box.php' ) ) {
		deactivate_plugins( 'meta-box/meta-box.php' );
		add_action( 'admin_notices', function () {
			?>
			<div class="notice notice-warning is-dismissible">
				<p>
					<strong><?php esc_html_e( 'Meta Box plugin has been deactivated!', 'easy-tours' ); ?></strong>
					<?php esc_html_e( 'Its functionality is embedded within the Inspiry Tours plugin.', 'easy-tours' ); ?>
				</p>
				<p>
					<em><?php esc_html_e( 'So, You should remove it completely from your plugins.', 'easy-tours' ); ?></em>
				</p>
			</div>
			<?php
		} );
	}

	// Meta Box Columns Extension
	if ( is_plugin_active( 'meta-box-columns/meta-box-columns.php' ) ) {
		deactivate_plugins( 'meta-box-columns/meta-box-columns.php' );
		add_action( 'admin_notices', function () {
			?>
			<div class="notice notice-warning is-dismissible">
				<p>
					<strong><?php esc_html_e( 'Meta Box Columns plugin has been deactivated!', 'easy-tours' ); ?></strong>
					&nbsp;<?php esc_html_e( 'Its functionality is embedded within the Inspiry Tours plugin.', 'easy-tours' ); ?>
				</p>
				<p>
					<em><?php esc_html_e( 'So, You should remove it completely from your plugins.', 'easy-tours' ); ?></em>
				</p>
			</div>
			<?php
		} );
	}

	// Meta Box Tabs Extension
	if ( is_plugin_active( 'meta-box-tabs/meta-box-tabs.php' ) ) {
		deactivate_plugins( 'meta-box-tabs/meta-box-tabs.php' );
		add_action( 'admin_notices', function () {
			?>
			<div class="notice notice-warning is-dismissible">
				<p>
					<strong><?php esc_html_e( 'Meta Box Tabs plugin has been deactivated!', 'easy-tours' ); ?></strong>
					&nbsp;<?php esc_html_e( 'Its functionality is embedded within the Inspiry Tours plugin.', 'easy-tours' ); ?>
				</p>
				<p>
					<em><?php esc_html_e( 'So, You should remove it completely from your plugins.', 'easy-tours' ); ?></em>
				</p>
			</div>
			<?php
		} );
	}

	// Meta Box Show Hide Extension
	if ( is_plugin_active( 'meta-box-show-hide/meta-box-show-hide.php' ) ) {
		deactivate_plugins( 'meta-box-show-hide/meta-box-show-hide.php' );
		add_action( 'admin_notices', function () {
			?>
			<div class="notice notice-warning is-dismissible">
				<p>
					<strong><?php esc_html_e( 'Meta Box Show Hide plugin has been deactivated!', 'easy-tours' ); ?></strong>
					&nbsp;<?php esc_html_e( 'Its functionality is embedded within the Inspiry Tours plugin.', 'easy-tours' ); ?>
				</p>
				<p>
					<em><?php esc_html_e( 'So, You should remove it completely from your plugins.', 'easy-tours' ); ?></em>
				</p>
			</div>
			<?php
		} );
	}

	// Meta Box Group Extension
	if ( is_plugin_active( 'meta-box-group/meta-box-group.php' ) ) {
		deactivate_plugins( 'meta-box-group/meta-box-group.php' );
		add_action( 'admin_notices', function () {
			?>
			<div class="notice notice-warning is-dismissible">
				<p>
					<strong><?php esc_html_e( 'Meta Box Group plugin has been deactivated!', 'easy-tours' ); ?></strong>
					&nbsp;<?php esc_html_e( 'Its functionality is embedded within the Inspiry Tours plugin.', 'easy-tours' ); ?>
				</p>
				<p>
					<em><?php esc_html_e( 'So, You should remove it completely from your plugins.', 'easy-tours' ); ?></em>
				</p>
			</div>
			<?php
		} );
	}

} );

// Embedded meta box plugin
if ( ! class_exists( 'RWMB_Core' ) ) {
	require_once( plugin_dir_path( __DIR__ ) . '/includes/meta-box/meta-box.php' );
}

/**
 * Meta Box Plugin Extensions
 */

// Columns extension
require_once( plugin_dir_path( __DIR__ ) . '/includes/meta-box-extensions/meta-box-columns/meta-box-columns.php' );

// Show Hide extension
require_once( plugin_dir_path( __DIR__ ) . '/includes/meta-box-extensions/meta-box-show-hide/meta-box-show-hide.php' );

// Tabs extension
require_once( plugin_dir_path( __DIR__ ) . '/includes/meta-box-extensions/meta-box-tabs/meta-box-tabs.php' );

// Group extension
require_once( plugin_dir_path( __DIR__ ) . '/includes/meta-box-extensions/meta-box-group/meta-box-group.php' );

// Term Meta extension
require_once( plugin_dir_path( __DIR__ ) . '/includes/meta-box-extensions/mb-term-meta/mb-term-meta.php' );